
flibrary+buffered+global DATAMAPS <
   libdeps="DMAP"
> {

macro+Datamap DefaultLinear {
  DMAP.DatamapValue DatamapValue[2];
  !DatamapValue[0] { 
    v1 = 0.0; 
    v2 = 0.66; 
    v3 = 1.0; 
    v4 = 1.0;
  };
  !DatamapValue[1] { 
    v1 = 1.0; 
    v2 = 0.0; 
    v3 = 1.0; 
    v4 = 1.0;
  };

  DMAP.DefaultDataRange DataRange[1];
  !DataRange[0] {
    controlPoints => {<-.DatamapValue[0], <-.DatamapValue[1]};
    // The idea with the "0 +" here and in other datamaps is that we want
    // these links to be fragile.  If the user changes the min or max of
    // a range, we do NOT want the changes flowing up the connection to alter
    // dataMin or dataMax.  Instead, we want the connetion to break.  The
    // datamap editor knows to break the connection first, but restoring
    // datamaps saved in V won't work properly without this change.
    // CFS PR 9422.
    DataMinValue => 0 + <-.dataMin;
    UIMinValue = 0.0;
    DataMaxValue => 0 + <-.dataMax;
    UIMaxValue = 255.0;
    minActive = 1;
    maxActive = 1;
    sizeActive = 1;
    selectValues = 0;
    selectAlphaRange = 1;
    selectColorRange = 0;
  };
  editable = 1;
  /* allows merge operation to work properly. */
  dataMin =;
  dataMax =;
  currentColorModel = 0;
  colorModel => ColorModels.models[currentColorModel];
  ranges+IPort => DataRange;

  /* For compatibility, we need to have minvalue and
     maxvalue around so if people had actually modified
     them, they will be able to access them.
  */
  DMAP.DatamapValue &minvalue => DatamapValue[0];
  DMAP.DatamapValue &maxvalue => DatamapValue[1];
};

macro+Datamap GreyScale {
  DatamapValue DatamapValue[2];
  !DatamapValue[0] { 
    v1 = 0.0; 
    v2 = 0.0; 
    v3 = 0.0; 
    v4 = 0.0;
  };
  !DatamapValue[1] { 
    v1 = 1.0; 
    v2 = 0.0; 
    v3 = 0.0; 
    v4 = 1.0;
  };

  DefaultDataRange DataRange[1];
  !DataRange[0] {
    controlPoints => {<-.DatamapValue[0], <-.DatamapValue[1]};
    DataMinValue => 0 + <-.dataMin;
    UIMinValue = 0.0;
    DataMaxValue => 0 + <-.dataMax;
    UIMaxValue = 255.0;
    minActive = 1;
    maxActive = 1;
    sizeActive = 1;
    selectValues = 0;
    selectAlphaRange = 1;
    selectColorRange = 0;
  };
  editable = 1;
  /* allows merge operation to work properly. */
  dataMin =;
  dataMax =;
  currentColorModel = 0;
  colorModel => ColorModels.models[currentColorModel];
  ranges+IPort => DataRange;
};

macro+Datamap VolumeRender {

  /* Four controls points for the two ranges.

     We want to always keep a linear color ramp from
     minvalue to maxvalue but allow the midvalue to
     move around. This is specifically to allow a
     reasonable manipulation of alpha without
     changing the colors. Of course all this would
     be a lot easier if color and alpha were kept
     separately.
  */
  float+nres ratio => (DataRange[0].UIMaxValue - DataRange[0].UIMinValue) / (dataMax - dataMin);
  DatamapValue DatamapValue[4];
  !DatamapValue[0] { 
    v1 = 0.0; 
    v2 = 0.66; 
    v3 = 1.0; 
    v4 = 1.0;
  };
  /* Two control points with the same RGB values but different alpha values */
  !DatamapValue[1] { 
    v1 = 0.0; 
    v2 => <-.DatamapValue[0].v2 + ((<-.DatamapValue[3].v2 - <-.DatamapValue[0].v2) * 
          ratio); 
    v3 => <-.DatamapValue[0].v3 + ((<-.DatamapValue[3].v3 - <-.DatamapValue[0].v3) * 
          ratio); 
    v4 => <-.DatamapValue[0].v4 + ((<-.DatamapValue[3].v4 - <-.DatamapValue[0].v4) * 
          ratio); 
  };
  !DatamapValue[2] { 
    v1 = 1.0; 
    v2 => <-.DatamapValue[0].v2 + ((<-.DatamapValue[3].v2 - <-.DatamapValue[0].v2) * 
          ratio); 
    v3 => <-.DatamapValue[0].v3 + ((<-.DatamapValue[3].v3 - <-.DatamapValue[0].v3) * 
          ratio); 
    v4 => <-.DatamapValue[0].v4 + ((<-.DatamapValue[3].v4 - <-.DatamapValue[0].v4) * 
          ratio); 
  };
  !DatamapValue[3] { 
    v1 = 1.0;
    v2 = 0.0;
    v3 = 1.0; 
    v4 = 1.0;
  };

  float min_array[3] = {0.0, 0.0, -32768.0};
  float mid_array[3] = {127.5, 2047.5, -0.5 };
  float max_array[3] = {255.0, 4095.0, 32767.0};

  int VolRenderRangeSize => (dataMax - dataMin) + 1;

  int index => switch((VolRenderRangeSize == 256) + 1, switch((VolRenderRangeSize == 4096) + 1, 2, 1), 0);

  /* Two ranges: This is done so we can set the alpha component to 
     Step (instead of Linear) and be able to slide the data value 
     for the middle control point.
  */
  DefaultDataRange DataRange[2];
  !DataRange[0] {
    size => VolRenderRangeSize * ratio;
    controlPoints => {<-.DatamapValue[0], <-.DatamapValue[1]};

    DataMinValue => 0 + <-.dataMin;
    DataMaxValue => <-.dataMin + ((<-.dataMax - <-.dataMin) * ratio);
    UIMinValue => min_array[index];
    UIMaxValue => mid_array[index];
    minActive = 1;
    maxActive = 0;
    sizeActive = 0;
    /*selectValues = 1;*/
    selectAlphaRange = 1;
    selectColorRange = 0;
  };

  !DataRange[1] {
    size => VolRenderRangeSize - DataRange[0].size;
    controlPoints => {<-.DatamapValue[2], <-.DatamapValue[3]};
    DataMinValue => <-.dataMin + ((<-.dataMax - <-.dataMin) * ratio);
    DataMaxValue => 0 + <-.dataMax;
    UIMinValue => DataRange[0].UIMaxValue;
    UIMaxValue => max_array[index];
    minActive = 0;
    maxActive = 1;
    sizeActive = 0;
    /*selectValues = 1;*/
    selectAlphaRange = 1;
    selectColorRange = 0;
  };

  editable = 0;
  /* allows merge operation to work properly. */
  dataMin =;
  dataMax =;
  currentColorModel = 0;
  colorModel => ColorModels.models[currentColorModel];
  ranges+IPort => DataRange;
};

macro+Datamap HotMetal {

  /* Four controls points for the three ranges. The
     middle control points will be shared between the
     ranges.
  */
  DatamapValue DatamapValue[4];
  !DatamapValue[0] { 
    v1 = 1.0; 
    v2 = 0.0; 
    v3 = 0.0; 
    v4 = 0.0;
  };
  !DatamapValue[1] { 
    v1 = 1.0; 
    v2 = 1.0; 
    v3 = 0.0; 
    v4 = 0.0;
  };
  !DatamapValue[2] { 
    v1 = 1.0; 
    v2 = 1.0; 
    v3 = 0.5; 
    v4 = 0.0;
  };
  !DatamapValue[3] { 
    v1 = 1.0; 
    v2 = 1.0; 
    v3 = 1.0; 
    v4 = 1.0;
  };

  /* Three ranges. */
  DefaultDataRange DataRange[3];
  !DataRange[0] {
    size = 128;
    controlPoints => {<-.DatamapValue[0], <-.DatamapValue[1]};

    DataMinValue => 0 + <-.dataMin;
    DataMaxValue => <-.dataMin + ((<-.dataMax - <-.dataMin) * 0.5);
    UIMinValue = 0.0;
    UIMaxValue = 127.5;
    minActive = 1;
    maxActive = 1;
    sizeActive = 1;
    selectValues = 0;
    selectAlphaRange = 0;
    selectColorRange = 0;
  };
  !DataRange[1] {
    size = 64;
    controlPoints => {<-.DatamapValue[1], <-.DatamapValue[2]};

    DataMinValue => DataRange[0].DataMaxValue;
    DataMaxValue => <-.dataMin + ((<-.dataMax - <-.dataMin) * 0.75);
    UIMinValue = 127.5;
    UIMaxValue = 191.25;
    minActive = 1;
    maxActive = 1;
    sizeActive = 1;
    selectValues = 0;
    selectAlphaRange = 0;
    selectColorRange = 0;
  };
  !DataRange[2] {
    size = 64;
    controlPoints => {<-.DatamapValue[2], <-.DatamapValue[3]};

    DataMinValue => DataRange[1].DataMaxValue;
    DataMaxValue => 0 + <-.dataMax;
    UIMinValue = 191.25;
    UIMaxValue = 255.0;
    minActive = 1;
    maxActive = 1;
    sizeActive = 1;
    selectValues = 0;
    selectAlphaRange = 0;
    selectColorRange = 0;
  };

  editable = 0;
  /* allows merge operation to work properly. */
  dataMin =;
  dataMax =;
  currentColorModel = 1;
  colorModel => ColorModels.models[currentColorModel];
  ranges+IPort => DataRange;
};

macro+Datamap CyanYellowRed {

  /* Three controls points for the two ranges. The
     middle control point will be shared between the
     ranges.
  */
  DatamapValue DatamapValue[3];
  !DatamapValue[0] { 
    v1 = 1.0; 
    v2 = 0.0; 
    v3 = 1.0; 
    v4 = 1.0;
  };
  !DatamapValue[1] { 
    v1 = 1.0; 
    v2 = 1.0; 
    v3 = 1.0; 
    v4 = 0.0;
  };
  !DatamapValue[2] { 
    v1 = 1.0; 
    v2 = 1.0; 
    v3 = 0.0; 
    v4 = 0.0;
  };

  /* Two ranges. */
  DefaultDataRange DataRange[2];
  !DataRange[0] {
    size = 128;
    controlPoints => {<-.DatamapValue[0], <-.DatamapValue[1]};

    DataMinValue => 0 + <-.dataMin;
    DataMaxValue => <-.dataMin + ((<-.dataMax - <-.dataMin) * 0.5);
    UIMinValue = 0.0;
    UIMaxValue = 127.5;
    minActive = 1;
    maxActive = 1;
    sizeActive = 1;
    selectValues = 0;
    selectAlphaRange = 0;
    selectColorRange = 0;
  };
  !DataRange[1] {
    size = 128;
    controlPoints => {<-.DatamapValue[1], <-.DatamapValue[2]};

    DataMinValue => DataRange[0].DataMaxValue;
    DataMaxValue => 0 + <-.dataMax;
    UIMinValue = 127.5;
    UIMaxValue = 255.0;
    minActive = 1;
    maxActive = 1;
    sizeActive = 1;
    selectValues = 0;
    selectAlphaRange = 0;
    selectColorRange = 0;
  };

  editable = 0;
  /* allows merge operation to work properly. */
  dataMin =;
  dataMax =;
  currentColorModel = 1;
  colorModel => ColorModels.models[currentColorModel];
  ranges+IPort => DataRange;
};

macro+Datamap DefaultStep {
  DatamapValue DatamapValue[4] {
    !DatamapValue[0] {        /* red */
      v1 = 1.0;
      v2 = 0.0;
      v3 = 1.0;
      v4 = 1.0;
    };
    !DatamapValue[1] {        /* yellow */
      v1 = 1.0;
      v2 = 0.16;
      v3 = 1.0;
      v4 = 1.0;
    };
    !DatamapValue[2] {        /* green */
      v1 = 1.0;
      v2 = 0.33;
      v3 = 1.0;
      v4 = 1.0;
    };
    !DatamapValue[3] {        /* blue */
      v1 = 1.0;
      v2 = 0.66;
      v3 = 1.0;
      v4 = 1.0;
    };
  };

  DefaultDataRange DataRange[1];
  !DataRange[0] {
    size = 4;
    controlPoints => {<-.DatamapValue[0], <-.DatamapValue[1], 
	<-.DatamapValue[2],<-.DatamapValue[3]};

    DataMinValue => 0 + <-.dataMin;
    DataMaxValue => 0 + <-.dataMax;
    UIMinValue = 0.0;
    UIMaxValue = 255.0;
    minActive = 1;
    maxActive = 1;
    sizeActive = 1;
    selectValues = 0;
    selectAlphaRange = 1;
    selectColorRange = 1;
  };

  editable = 0;
  /* allows merge operation to work properly. */
  dataMin =;
  dataMax =;
  currentColorModel = 0;
  colorModel => ColorModels.models[currentColorModel];
  ranges+IPort => DataRange;
};

macro+Datamap FilterDatamap {

  /* Three controls points for the three ranges. Each range
     will have unique control points but the ranges
     will be linked.
  */

  DatamapValue DatamapValue[3];
  /* Lower range is blue */
  !DatamapValue[0]  { 
    v1 = 1.0; 
    v2 = 0.0; 
    v3 = 0.0; 
    v4 = 1.0;
  };
  /* Middle range is green */
  !DatamapValue[1] { 
    v1 = 1.0; 
    v2 = 0.0; 
    v3 = 1.0; 
    v4 = 0.0;
  };
  /* Upper range is red */
  !DatamapValue[2] { 
    v1 = 1.0; 
    v2 = 1.0; 
    v3 = 0.0; 
    v4 = 0.0;
  };

  /* Three ranges - blue, green, red */
  DefaultDataRange DataRange[3];
  !DataRange[0] {
    size => 10;
    controlPoints => {<-.DatamapValue[0]};

    DataMinValue => 0 + <-.dataMin;
    DataMaxValue => <-.dataMin + ((<-.dataMax - <-.dataMin) * 0.33);
    UIMinValue = 0.0;
    UIMaxValue = 127.5;
    minActive = 0;
    maxActive = 1;
    sizeActive = 1;
    selectValues = 0;
    selectAlphaRange = 1;
    selectColorRange = 1;
  };
  !DataRange[1] {
    size = 10;
    controlPoints => {<-.DatamapValue[1]};

    DataMinValue => <-.dataMin + ((<-.dataMax - <-.dataMin) * 0.33);
    DataMaxValue => <-.dataMin + ((<-.dataMax - <-.dataMin) * 0.66);
    UIMinValue = 127.5;
    UIMaxValue = 191.25;
    minActive = 1;
    maxActive = 1;
    sizeActive = 1;
    selectValues = 0;
    selectAlphaRange = 1;
    selectColorRange = 1;
  };
  !DataRange[2] {
    size = 10;
    controlPoints => {<-.DatamapValue[2]};

    DataMinValue => <-.dataMin + ((<-.dataMax - <-.dataMin) * 0.66);
    DataMaxValue => 0 + <-.dataMax;
    UIMinValue = 191.25;
    UIMaxValue = 255.0;
    minActive = 1;
    maxActive = 0;
    sizeActive = 1;
    selectValues = 0;
    selectAlphaRange = 1;
    selectColorRange = 1;
  };

  currentColorModel = 1;
  editable = 1;
  /* allows merge operation to work properly. */
  dataMin =;
  dataMax =;
  colorModel => ColorModels.models[currentColorModel];
  ranges+IPort => DataRange;
};

};
