/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/advect.v#1 $
*/

APPS.MultiWindowApp Advect<NEdisplayMode="maximized",
                           NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "Advect demonstrates how you can achieve particle advection through a volume which has a uvw vector node data component. This example uses the aeroplane bluntfin.fld data, the advected particles being the airflow across the plane fin.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=44.,NEx=253.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.combine_vect combine_vect<NEy=132.,NEx=385.> {
      in_field => Read_UCD.field;
      CombineVectParam {
         components = {1,2,3};
      };
   };
   GEOMS.FPlane FPlane<NEy=132.,NEx=572.> {
      in => Read_UCD.field;
   };
   GEOMS.Arrow2 Arrow2<NEy=253.,NEx=627.>;
   MODS.advector advector<NEy=286.,NEx=297.> {
      in_field => combine_vect.out_fld;
      in_glyph => Arrow2.out_fld;
      in_probe => FPlane.out_fld;
      AdvectParam {
         count = 1.;
         incr = 0.1;
         scale = 0.37;
      };
   };
   MODS.external_edges external_edges<NEy=132.,NEx=198.> {
      in_field => Read_UCD.field;
   };
   MODS.magnitude magnitude<NEx=462.,NEy=341.> {
      in_field => <-.advector.out_fld1;
   };
   GDM.Uviewer3D Uviewer3D<NEx=209.,NEy=429.> {
      Scene {
         Top {
            child_objs => {advector.out_obj,
               external_edges.out_obj,<-.<-.<-.magnitude.out_obj};
            Xform {
               mat = {
                  0.696951,0.23659,0.384212,0.,-0.215693,0.795653,-0.098686,0.,
-0.396321,-0.016971,0.729365,0.,0.,0.,0.,1.
               };
               xlate = {-0.314893,-1.7495,
-1.20709};
            };
         };
         Camera {
            Camera {
               auto_norm = 0;
            };
         };
         Lights {
            Lights = {
               {
                  type=3
               },,,};
         };
      };
      Scene_Editor {
         Light_Editor {
            GDlight_edit {
               type = 3;
            };
         };
      };
   };
};
