/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/clamp.v#1 $
*/

APPS.MultiWindowApp Clamp<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "The clamp macro is used when you want to clamp limits on data. The values outside the clamped \"range\" are set to either the min value and/or the max value. This example shows a typical approach in Express, that of using one module to prepare the data for a downstream module to process.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=33.,NEx=341.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.clamp clamp<NEy=88.,NEx=88.> {
      in_field => Read_UCD.field;
      ClampParam {
         min_value => 1.26;
      };
   };
   MODS.external_edges external_edges<NEy=88.,NEx=462.> {
      in_field => Read_UCD.field;
   };
   GEOMS.FPlane FPlane<NEy=88.,NEx=275.> {
      in => Read_UCD.field;
   };
   GEOMS.Axis3D Axis3D<NEy=88.,NEx=638.> {
      in_field => Read_UCD.field;
   };
   MODS.slice slice<NEy=209.,NEx=220.> {
      in_field => clamp.out_fld;
      in_plane => FPlane.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=297.,NEx=407.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               slice.out_obj,external_edges.out_obj};
            Xform {
               mat = {
                  0.690467,0.270401,0.491298,0.,-0.217402,0.847405,-0.160859,0.,
-0.516939,0.00478711,0.723868,0.,0.,0.,0.,1.
               };
               xlate = {-0.847957,-1.48429,-0.81961};
            };
         };
         Lights {
            Lights = {
               {
                  type=3
               },,,};
         };
      };
      Scene_Editor {
         Light_Editor {
            GDlight_edit {
               type = 3;
            };
         };
      };
   };
};
