/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/crop.v#1 $
*/

APPS.MultiWindowApp Crop<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "Crop shows the use of the crop macro. Note that the crop is performed before the isosurface to reduce processing time. The isosurface algorithm has less data to work with and so performs quickly. This is a useful technique for working with large volumes of data.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=55.,NEx=264.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds<NEy=165,NEx=473> {
      in_field => Read_Field.field;
   };
   MODS.crop crop<NEy=165,NEx=275> {
      in_field => Read_Field.field;
      CropParam {
         min = {0,10,10};
         max = {63,53,36};
      };
   };
   MODS.isosurface isosurface<NEy=286.,NEx=286.> {
      in_field => crop.out_fld;
   };
   GEOMS.Axis3D Axis3D<NEy=165.,NEx=99.> {
      in_field => Read_Field.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=374,NEx=484> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               isosurface.out_obj,bounds.out_obj};
            Xform {
               mat = {
                  0.0674297,-0.0226753,0.0805262,0.,-0.00560773,0.101969,0.0334092,
0.,-0.0834697,-0.0251685,0.0628074,0.,0.,0.,0.,1.
               };
               xlate = {-0.3085,-2.34535,-5.18459};
            };
         };
      };
      Scene_Editor {
         Light_Editor {
            GDlight_edit {
               type = 0;
            };
         };
      };
   };
};
