/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/cty_plot.v#1 $
*/

APPS.MultiWindowApp City_Plot<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "City_Plot shows how to use the city_plot macro. It is one of several methods to give a 3D look to 2D data. Note the use of downsize to preprocess the data into a reduced data volume 2D slice.";
      helpfile = "examples/examples_help.htm";
   };

   HDF5.Rd_HDF5_Field Rd_HDF5_Field<NEy=44.,NEx=165.> {
      Rd_HDF5_Param {
         filename = "$XP_PATH<0>/data/hdf5/hydrogen2d.h5";
         trigger = 1;
      };
   };
   MODS.downsize downsize<NEy=110.,NEx=165.> {
      DownsizeParam {
         factor0 = 4.;
         factor1 = 4.;
         factor2 = 4.;
      };
      in_field => <-.Rd_HDF5_Field.out_fld;
   };
   MODS.city_plot city_plot<NEx=165.,NEy=231.> {
      CityParam {
         scale = 0.31;
      };
      obj {
         Modes {
            mode = {0,2,3,0,0};
         };
      };
      in_field => downsize.out_fld;
   };
   GEOMS.Axis3D Axis3D<NEy=319.,NEx=110.> {
      obj {
         Props {
            col = {0.7,0.7,0.7};
         };
      };
      in_field => <-.city_plot.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=363.,NEx=319.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               city_plot.out_obj};
            Xform {
               mat = {
                  -0.0382926,0.053012,-0.0349058,0.,-0.0598583,-0.0166026,0.0404517,
0.,0.0211107,0.0490825,0.0513834,0.,0.,0.,0.,1.
               };
               xlate = {-3.03667,-3.58615,-10.134};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
