/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/curl.v#1 $
*/

APPS.MultiWindowApp Curl<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows how the curl macro is used to calculate the curl in a vector field. Note that in this example you can select the Plane object in the viewer by using <CTRL>LMB and then transform the plane. The curl macro recalculates the curl and the visualization is updated. Note the use of the interp_data macro which interpolates the node data values on the provided probe field. In this case the probe field is generated by the instance of the FPlane macro.";
      helpfile = "examples/examples_help.htm";
#ifdef MSDOS
      UItext.rows = 12;
#else
      UItext.rows = 14;
#endif
   };

   MODS.Read_UCD Read_UCD<NEy=22,NEx=264> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/box.inp";
      };
   };
   MODS.combine_vect combine_vect<NEy=77,NEx=385> {
      in_field => Read_UCD.field;
   };
   MODS.curl curl<NEy=165,NEx=363> {
      in_field => combine_vect.out_fld;
   };
   GEOMS.FPlane Plane<NEy=220,NEx=605> {
      in => Read_UCD.field;
      obj {
         Modes {
            mode => {
               0,1,0,0,0
            };
         };
      };
   };
   GEOMS.Arrow1 Arrow1<NEy=297,NEx=484>;
   MODS.interp_data interp_data<NEy=264,NEx=363> {
      in_field => curl.out_fld;
      in_probe => Plane.out_fld;
   };
   MODS.glyph glyph<NEy=363,NEx=363> {
      in_field => interp_data.out_fld;
      in_glyph => Arrow1.out_fld;
      GlyphParam {
         normalize = 1;
      };
   };
   MODS.external_edges external_edges1<NEy=363,NEx=198> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=429,NEx=528> {
      Scene {
         Top {
            child_objs => {glyph.out_obj,
               Plane.out_obj,external_edges1.out_obj};
            Xform {
               mat = {
                  1.66744,-0.443471,-1.62748,0.,-0.115961,2.25287,-0.732692,0.,
1.68283,0.594655,1.56212,0.,0.,0.,0.,1.
               };
               xlate = {6.40298,0.200399,11.1098};
            };
         };
      };
   };
};
