/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/cut.v#1 $
*/

APPS.MultiWindowApp Cut<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "Cut demonstrates the use of the cut macro. The FPlane macro generates the cut plane to use and a Read_UCD macro is used to read in the bluntfin data. After the cut, the external_faces macro allows for the (faster) rendering of just the outside faces of the generated field.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=55.,NEx=176.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   GEOMS.FPlane FPlane<NEy=121.,NEx=275.> {
      in => Read_UCD.field;
   };
   MODS.cut cut<NEy=187.,NEx=198.> {
      in_field => Read_UCD.field;
      in_plane => FPlane.out_fld;
      CutParam {
         component = {0};
         dist = 0.66;
         above = 1;
      };
   };
   MODS.external_edges external_edges<NEy=121.,NEx=451.> {
      in_field => Read_UCD.field;
   };
   MODS.external_faces external_faces<NEy=264.,NEx=264.> {
      in_field => cut.out_fld;
   };
   GEOMS.Axis3D Axis3D<NEy=121.,NEx=44.> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=407.,NEx=176.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               external_faces.out_obj,external_edges.out_obj};
            Xform {
               mat = {
                  -0.569079,-0.238686,0.640636,0.,0.146968,0.77134,0.417934,0.,
-0.667672,0.373227,-0.454039,0.,0.,0.,0.,1.
               };
               xlate = {-0.847957,-1.48429,-0.81961};
            };
         };
      };
   };
};
