/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/cut_txt.v#1 $
*/

APPS.MultiWindowApp Cut_Texture<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows how the macro cut_texture3D is used. Note the use of a colormap to provide the texture that is used by cut_texture3D.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=33.,NEx=198.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds<NEy=99.,NEx=66.> {
      in_field => Read_Field.field;
   };
   DATAS.colormap colormap<NEy=143.,NEx=462.>;
   GEOMS.FPlane FPlane<NEy=99.,NEx=308.> {
      in => Read_Field.field;
   };
   MODS.cut_texture3D cut_texture3D<NEy=209.,NEx=242.> {
      texture_map => colormap;
      in_field => Read_Field.field;
      in_plane => FPlane.out_fld;
      CutParam {
         component = {0};
         dist = -6.;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEy=330.,NEx=187.> {
      Scene {
         Top {
            child_objs => {
               cut_texture3D.out_obj,bounds.out_obj};
            Xform {
               mat = {
                  0.0658114,0.0378827,0.0544092,0.,-0.0401936,0.0837668,-0.00970644,
0.,-0.0527252,-0.0165721,0.0753129,0.,0.,0.,0.,1.
               };
               xlate = {-5.,-5.,-5.};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
