/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/cyl_plot.v#1 $
*/

APPS.MultiWindowApp Cylinder_Plot<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=40.,NEy=280.> {
      demo_text = "This example shows how to create a visualization with cylinders placed in a geographical context. The data for the pie / vertical segments is contained as node data in the population_data field. The first 6 values are used as the blue segment data, the next 6 as the green segment data and the last 6 as the blue segment data. The cell centers macro creates a field containing the centers of the cells read in by the Read_USCounties macro.";
      helpfile = "examples/examples_help.htm";
#ifdef MSDOS
      UItext.rows = 12;
#else
      UItext.rows = 14;
#endif
   };

   MODS.Read_USCounties Read_USCounties<NEx=253.,NEy=22.,NEwidth=429.,NEheight=231.> {
        rd_counties {
          filename = "$XP_PATH<0>/data/gis/uscount";
          state_no = 9;
        };
   };
   MODS.cell_centers cell_centers<NEx=187.,NEy=121.> {
      in_field => <-.Read_USCounties.out_mesh;
   };
   Mesh_Unif+Node_Data population_data<NEcolor1=65280,NEcolor2=255,NEportLevels={0,1},NEx=22.,NEy=22.> {
      ndim = 2;
      nspace = 2;
      dims = {6,3};
      nnode_data = 1;
      node_data {
         veclen = 1;
      } = {
         {
            values=
            {
               10,12,14,13,11,10,40,24,36,21,22,36,33,35,25,26,30,28
            },,,,,,,,,
         }};
      points = {0.,0.,1.,1.};
   };
   MODS.cylinder_plot_unif cylinder_plot_unif<NEx=77.,NEy=198.> {
      in_field => <-.population_data;
      in_locations => <-.cell_centers.out_fld;
      CylParam<NEx=11.,NEy=99.> {
         scale => 0.004;
         radius => 0.045;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=297.,NEy=297.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.Read_USCounties.out_obj,
               <-.<-.<-.cylinder_plot_unif.out_obj};
            Xform {
               mat = {
                  6.88389,0.527319,-1.4565,0.,-1.40074,4.95171,-4.82761,0.,
0.661347,4.99899,4.9356,0.,0.,0.,0.,1.
               };
               xlate = {-292.94,-156.594,-0.65243};
            };
         };
      };
   };
};
