/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/disp_vol.v#1 $
*/

APPS.MultiWindowApp Display_Vol_ROI<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "Using the RMB click a series of polygon points on the yellow/green orthoslice. To finish the polygon use <CTRL>RMB. Then select Modules->copy_ROI and click the Run toggle. This copies the ROI that you have sketched to each slice in the volume. If you rotate the blue/green orthoslice you will see the ROI. If you now select Modules->display_volROI you will be able to change the slice plane that you are looking at. To edit the mesh use <CTRL>LMB and move the red representation of the line whilst holding down this <CTRL>LMB combination. The edit you made here will only be applied to this selected slice.";
      helpfile = "examples/examples_help.htm";
      UItext {
         rows = 15;
      };   
   };

   MODS.Readers.Read_Field Read_Field<NEx=418,NEy=66> {
      read_field_ui {
         file_browser {
            filename = "$XP_PATH<0>/data/field/wind.fld";
         };
      };
   };
   MODS.Mappers.orthoslice orthoslice<NEx=242,NEy=121> {
      in_field => <-.Read_Field.field;
      OrthoSliceParam<NEx=11,NEy=55> {
         axis = 2;
      };
   };
   MODS.Filters.reset_xform reset_xform<NEx=242,NEy=176> {
      in_field => <-.orthoslice.out_fld;
   };
   GDM.Interactivity.ClickSketch ClickSketch<NEx=187,NEy=297> {
      view_in => Uviewer2D.Scene_Selector.curr_view;
      obj_in => reset_xform.out_obj;
      click_sketch {
         GDroi2d_click<NEx=319,NEy=407> {
            option = 4;
            immed = 1;
         };
         GDmap2d_ss<NEx=319,NEy=451> {
            mode = 1;
         };
      };
   };
   MODS.Mappers.copy_ROI copy_ROI<NEx=528,NEy=242> {
      FieldIn => <-.Read_Field.field;
      MeshIn => <-.ClickSketch.click_sketch.GDmap2d_ss.out_mesh;
      loop {
         count = 32;
      };
      UIfieldTypein#1 {
         field<NEx=11,NEy=143> {
            value = 32;
         };
      };
   };
   MODS.Mappers.display_vol_ROI display_vol_ROI<NEx=484,NEy=308> {
      FieldIn => <-.Read_Field.field;
      MeshIn => <-.copy_ROI.DVswitch.out;
   };
   GDM.Uviewer2D Uviewer2D<NEx=418.,NEy=385.> {
      Scene {
         Top {
            child_objs => {reset_xform.out_obj,ClickSketch.click_sketch.DataObject.obj};
         };
      };
      GDM.Uscene3D Scene#1 {
         Top {
            child_objs<NEportLevels={4,1}> => {display_vol_ROI.GroupObject.obj}; 
         };
      };
      Scene_Selector {
         input_views => {Scene.View.View,
            <-.Scene#1.View.View};
      };
   };
   GDM.Interactivity.EditMesh EditMesh<NEx=407,NEy=462> {
      view_in => Uviewer2D.Scene_Selector.curr_view;
   };
};
