/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/down.v#1 $
*/

APPS.MultiWindowApp Downsize<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "Downsize is a simple example to demonstrate the use of the downsize macro. It is a very useful macro to use when you are developing a network to reduce the amount of data that the network has to process. It is also very useful when you are using large amounts of data and you just want a holistic visual view of it.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=33.,NEx=143.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   GEOMS.Axis3D Axis3D<NEy=110.,NEx=33.> {
      in_field => Read_Field.field;
   };
   MODS.downsize downsize<NEy=110.,NEx=231.> {
      in_field => Read_Field.field;
   };
   MODS.isosurface isosurface<NEy=209.,NEx=220.> {
      in_field => downsize.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=319.,NEx=132.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               isosurface.out_obj};
            Xform {
               mat = {
                  0.0883414,0.000929448,0.0521903,0.,-0.0191047,0.0960513,0.0306276,
0.,-0.0485768,-0.0360857,0.0828674,0.,0.,0.,0.,1.
               };
               xlate = {-4.09194,-4.05158,-4.38469};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
