/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/excvt.v#1 $
*/

APPS.MultiWindowApp Excavate_Brick<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=160> {
      demo_text = "Excavate_Brick shows how to use the excavate_brick3D macro. This macro is texture map based - you supply a texture map to be used and you can modify the X,Y and Z \"excavations\" that are performed.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=22.,NEx=143.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds<NEy=99.,NEx=77.> {
      in_field => Read_Field.field;
   };
   DATAS.colormap colormap<NEy=22.,NEx=330.>;
   MODS.excavate_brick3D excavate_brick3D<NEy=99.,NEx=264.> {
      texture_map => colormap;
      in_field => Read_Field.field;
      ExcBrickParam {
         x = 21;
         draw_sides = 1;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEy=231.,NEx=165.> {
      Scene {
         Top {
            child_objs => {
               excavate_brick3D.out_obj,bounds.out_obj};
            Xform {
               mat = {
                  0.0688749,-0.00748734,0.0682907,0.,-0.026452,0.086355,0.0361462,
0.,-0.0634033,-0.044161,0.0591039,0.,0.,0.,0.,1.
               };
               xlate = {-5.,-5.,-5.};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
