/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/explode.v#1 $
*/

APPS.MultiWindowApp Explode_Fields<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "Explode_Fields shows a typical network that is used to separate a single field into several fields by comparing values in the cell props array. In this example, six orginal cell sets are are separated into four different fields.  For example Read_UCD.field.cell_set[0].props has a value of {1}, so is output in its own field with any other cell set with a props value of 1. explode_materials does the initial separation into four fields. explode_fields alters the coordinates of the fields to separate them visually. Note the use of the xxx_ARR macros to process arrays of fields.";
      helpfile = "examples/examples_help.htm";
      UItext.rows = 15;
   };

   MODS.Read_UCD Read_UCD<NEx=154,NEy=77> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/avs.inp";
      };
   };
   MODS.explode_materials explode_materials<NEx=143,NEy=165> {
      in_field => <-.Read_UCD.field;
   };
   MODS.explode_fields explode_fields<NEx=143,NEy=253> {
      in_fields => <-.explode_materials.out_fld;
      explode_param {
         scale_x = 0.8;
         scale_y = 1.5;
      };
   };
   MODS_ARR.external_edges_ARR external_edges_ARR<NEx=154,NEy=341> {
      in_field => <-.explode_fields.out_fld;
   };
   MODS_ARR.slice_plane_ARR slice_plane_ARR<NEx=374,NEy=308> {
      in_field => <-.explode_fields.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEx=253,NEy=440> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.external_edges_ARR.out_obj,
               <-.<-.<-.slice_plane_ARR.out_obj_slice};
            Xform {
               mat = {
                  0.199573,0.0183731,0.033613,0.,-0.0212596,0.201458,0.0161071,
0.,-0.0318659,-0.0193351,0.199768,0.,0.,0.,0.,1.
               };
               xlate = {-1.67265,0.608448,-3.43911};
            };
         };
         Lights {
            Lights = {
               {
                  type=3
               },,,};
         };
      };
      Scene_Editor {
         Light_Editor {
            GDlight_edit {
               type = 3;
            };
         };
      };
   };
};
