/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/fast_arr2.v#1 $
*/

APPS.SingleWindowApp Fast_ARR_2<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=220> {
      demo_text = "This demonstrates the use of some of the \"Fast\" xxx_ARR macros to process arrays of fields. The \"Fast\" macros in the FAST_ARR library are considerably faster than the standard xxx_ARR macros when the arrays contains hundreds of fields, which sometimes occurs in CFD applications.";
      helpfile = "examples/examples_help.htm";
   };

   UI {
      shell {
         x = 0;
         y = 0;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=319.,NEy=341.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.combine_sets.out_obj,
               <-.<-.<-.solid_contour_ARR.out_obj,
               <-.<-.<-.solid_contour_ARR.out_obj_line};
            Xform {
               mat = {
                  -0.443855,10.27,6.65098,0.,-4.69026,-6.28976,9.39923,0.,
11.3009,-2.20711,4.16224,0.,0.,0.,0.,1.
               };
               xlate = {-3.42088,-0.868536,
-2.41287};
            };
         };
      };
   };
   CFD.Read_PLOT3D read_plot3d<NEx=88.,NEy=33.> {
      ReadPlot3dParam {
         filename_xyz = "$XP_PATH<0>/data/plot3d/multb_x.dat";
         filename_q   = "$XP_PATH<0>/data/plot3d/multb_q.dat";
         trigger = 1;
      };
   };
   FAST_ARR.bounds_ARR bounds_ARR<NEx=341.,NEy=121.> {
      in_field => <-.read_plot3d.fields;
      objs.in_fields => ;
   };
   FAST_ARR.combine_sets_ARR combine_sets<NEx=473.,NEy=198.> {
      in_fields => <-.bounds_ARR.out_fld;
   };
   FAST_ARR.slice_plane_ARR slice_plane_ARR<NEx=88.,NEy=121.> {
      in_field => <-.read_plot3d.fields;
      SliceParam {
         component = {1};
         dist = -0.07;
      };
      SliceUI {
         plane_xform {
            GDxform_editor {
               x_rot = 90.;
               abs_x_rot = 90.;
            };
            XformEditorUI {
               trans_shell {
                  ok = 1;
               };
            };
         };
      };
      plane {
         xform {
            mat = {
               1.,0.,0.,0.,0.,5e-010,1.,0.,0.,-1.,5e-010,0.,0.,0.,0.,1.
            };
         };
      };
   };
   FAST_ARR.solid_contour_ARR solid_contour_ARR<NEx=187.,NEy=220.> {
      in_field => <-.slice_plane_ARR.out_fld;
      ContourParam {
         level_min => -1.19;
         level_max => 0.14;
         ncontours = 10;
         contour_lines = 1;
      };
   };
};
