/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/file_ucd.v#1 $
*/

APPS.MultiWindowApp File_Field_UCD<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows how data files can be read using the File Access Objects (the ucd_file and UCD_File_Field groups) to read bluntfin.inp.  Note that this example does *not* use Read_UCD to read the file.  This example is hard to understand visually - the best way to understand the this example is to look at the V code in v/dv_examp/file_ucd.v.";
      helpfile = "examples/examples_help.htm";
   };

   file ucd_file {
      name="$XP_PATH<0>/data/ucd/bluntfin.inp";
   };

   Mesh+Node_Data+OPort UCD_File_Field<NEy=130,NEx=140> {

      int file_beg => cache(file_skip_lines(ucd_file,0, 18)); /* skip header */

      nnodes => cache(		/* number of nodes */
         file_scalar_ascii(ucd_file, file_beg, 3));

      int rncells => cache(	/* number of cells */
         file_scalar_ascii(ucd_file, 
                           file_skip_words(ucd_file, file_beg, 1), 3));

      nspace = 3;		/* UCD always have nspace = 3 */
      coordinates {
         values => cache(	/* xyz arrays, skip first column: node index */
            file_array_ascii(ucd_file,
                             file_skip_lines(ucd_file,file_beg,1),
                             4, {0,1,1,1}));
      };

      ncell_sets = 1;		/* we can use file objects only for sorted cell types */

      Hex cell_set {
         ncells+nres => rncells;
         /* cell connectivity, skip 3 columns:       */
         /*    cell index, cell_type and material_id */
         node_connect_list => cache(	
				file_array_ascii(ucd_file,
						file_skip_lines(ucd_file,file_beg,1+nnodes),3,
							{0,0,0,1,1,1,1,1,1,1,1}) -1);
         };

         int ncomps = 5;   	/* number of components in file */

         nnode_data = 1;    	/* read just one first component */

         !node_data[0]{

            veclen => cache(	/* offset for veclen is rather involved...*/
               file_scalar_ascii(ucd_file,
                  file_skip_words(ucd_file, 
                     file_skip_lines(ucd_file, file_beg, 
                                     1+nnodes+rncells), 1), 3));

            float+nres values[nvals][veclen] => cache(	/* node data, just the second column */
               file_array_ascii(ucd_file,
                  file_skip_lines(ucd_file, file_beg,
                     2+nnodes+rncells+ncomps), 4, {0,1,0,0,0,0}));
	};
   };

   MODS.isosurface isosurface<NEy=198,NEx=473> {
      in_field => UCD_File_Field;
   };

   MODS.external_edges external_edges<NEy=220,NEx=297> {
      in_field => UCD_File_Field;
   };

   GDM.Uviewer3D Uviewer3D<NEy=440.,NEx=176.> {
      Scene {
         Top {
            child_objs => {isosurface.out_obj,
               external_edges.out_obj};
            Xform {
               mat = {
                  0.606388,0.047959,0.710945,0.,-0.246892,0.889846,0.150554,0.,
-0.668422,-0.28517,0.589355,0.,0.,0.,0.,1.
               };
               xlate = {-1.1513,-2.16129,-1.46212};
            };
         };
      };
   };
};
