/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/file_uni.v#1 $
*/

APPS.MultiWindowApp File_Field_Unif<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows how data files can be read using the File Access Objects (the header_file, data_file and Unif_File_Field groups) to read the hydrogen dataset.  Note that this example does *not* use Read_Field to read the file.  This example is hard to understand visually - the best way to understand the this example is to look at the V code in v/dv_examp/file_unif.v.";
      helpfile = "examples/examples_help.htm";
      UItext.rows = 10;
   };

   file header_file {
      name = "$XP_PATH<0>/data/field/hydrogen.fld";
   };
   file data_file<NEx=231.,NEy=77.> {
      name = "$XP_PATH<0>/data/volume/hydrogen.dat";
   };

   Mesh_Unif+Node_Data Unif_File_Field<NEcolor2=16776960,NEportLevels={0,1},NEx=154.,NEy=132.> {
      dims => {dim1,dim2,dim3};
      ndim => cache(file_scalar_ascii(header_file,file_find_expr(header_file,0,"ndim[ ]*=[ ]*"),3,,0));
      nnode_data = 1;
      node_data {
         veclen = 1;
      } = {
         {
            veclen=>
            cache(file_scalar_ascii(header_file,file_find_expr(header_file,0,"veclen[ ]*=[ ]*"),3,,0)),values=>
            file_obj_bin(data_file,3,1,,1),,,,,,,,,
         }};
      int dim1 => cache(file_scalar_ascii(header_file,file_find_expr(header_file,0,"dim1[ ]*=[ ]*"),3,,0));
      int dim2 => cache(file_scalar_ascii(header_file,file_find_expr(header_file,0,"dim2[ ]*=[ ]*"),3,,0));
      int dim3 => cache(file_scalar_ascii(header_file,file_find_expr(header_file,0,"dim3[ ]*=[ ]*"),3,,0));
      nspace => cache(file_scalar_ascii(header_file,file_find_expr(header_file,0,"nspace[ ]*=[ ]*"),3,,0));
      points[2][3] => {{0,0,0},
         {(dim1 - 1),
            (dim2 - 1),(dim3 - 1)}};
   };
   MODS.bounds bounds<NEy=220.,NEx=407.> {
      in_field => Unif_File_Field;
   };
   MODS.isosurface isosurface<NEy=220.,NEx=209.> {
      in_field => Unif_File_Field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=352.,NEx=231.> {
      Scene {
         Top {
            child_objs => {bounds.out_obj,
               isosurface.out_obj};
            Xform {
               mat = {
                  0.0707953,0.0120002,0.0589443,0.,-0.0322581,0.08441,0.021559,
0.,-0.0507726,-0.0368967,0.0684922,0.,0.,0.,0.,1.
               };
               xlate = {-5.,-5.,-5.};
            };
         };
      };
   };
};
