/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/g_glyph.v#1 $
*/

APPS.MultiWindowApp Geo_Glyph<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=200> {
      demo_text = "Geo_Glyph shows how you can create glyph output using the geo_glph macro. This macro allows you to supply an array of glyph geometries to be used as output glyphs. The input field node data is used as an index into the array of glyphs.  The mesh pattern you see in this example is the result of drawing the cross glyph at each node data location";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEx=176.,NEy=22.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds<NEx=22.,NEy=88.> {
      in_field => <-.Read_Field.field;
   };
   MODS.orthoslice orthoslice<NEx=198.,NEy=88.> {
      in_field => <-.Read_Field.field;
      OrthoSliceParam {
         axis = 2;
      };
   };
   GEOMS.Cross2D Cross2D<NEx=429.,NEy=22.>;
   GEOMS.Diamond2D Diamond2D<NEx=462.,NEy=77.>;
   GEOMS.Plane Plane<NEx=517.,NEy=121.> {
      dim1 = 2;
      dim2 = 2;
   };
   MODS.geo_glyph geo_glyph<NEx=264,NEy=209> {
      in_field => <-.orthoslice.out_fld;
      in_glyph => {<-.Cross2D.out_fld,
         <-.Diamond2D.out_fld,<-.Plane.out_fld};
      GlyphParam<NEx=11,NEy=99> {
         normalize<NEdisplayMode="NEopened"> = 1;
         color_r = 0.;
         color_g = 0.49;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=187.,NEy=297.> {
      Scene {
         Top {
            child_objs => {<-.<-.<-.geo_glyph.out_obj,
               <-.<-.<-.bounds.out_obj};
            Xform {
               mat = {
                  0.108352,-0.0113682,0.0281305,0.,0.0213897,0.102609,-0.0409211,
0.,-0.0215184,0.0447529,0.100969,0.,0.,0.,0.,1.
               };
               xlate = {-4.92188,-4.92188,-4.92188};
            };
         };
      };
   };
};
