/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/giscia.v#1 $
*/

APPS.SingleWindowApp GISMapDisplay<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "GISMapDisplay shows how you can read GIS Map data into Express. It also shows how GISGeneratePlanet can be used to generate a sphere to be used as the globe to project the map onto.";
      helpfile = "examples/examples_help.htm";
   };

   GIS_UI.GISWorldDataBank GISWorldDataBank {
      west_longitude {
         Dial {
            mode = "integer";
         };
      };
      east_longitude {
         Dial {
            mode = "integer";
         };
         value = 330.;
      };
      south_latitude {
         Dial {
            mode = "integer";
         };
         value = -85.;
      };
      north_latitude {
         Dial {
            mode = "integer";
         };
      };
      UImod_panel {
         option {
            set = 1;
         };
      };
      ingest.do = 1;
   };
   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.GISGeneratePlanet.SphereObject.obj,
               <-.<-.<-.GISMapTransform.MapObject#4.obj};
            Xform {
               mat = {
                  4.95042e-007,2.90988e-008,-6.04615e-008,0.,-6.56709e-008,1.17705e-007,
-4.81043e-007,0.,-1.37743e-008,4.84631e-007,1.20464e-007,0.,0.,0.,0.,1.
               };
               xlate = {-0.00804579,0.0142208,
-0.0201362};
            };
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 123;
                        defaultY = 170;
                     };
                  };
               };
            };
         };
      };
   };
   GIS_UI.GISMapTransform GISMapTransform {
      GISMeshProject#4 {
         in => <-.<-.GISWorldDataBank.GISCIAMapII.coastalPolylines;
      };
      BaseLat {
         Dial {
            mode = "real";
         };
      };
      BaseLon {
         Dial {
            mode = "real";
         };
      };
      FirstParallel {
         Dial {
            mode = "real";
         };
      };
      SecondParallel {
         Dial {
            mode = "real";
         };
      };
      Radius {
         value<NEportLevels={0,3}>;
      };
   };
   GIS_UI.GISGeneratePlanet GISGeneratePlanet {
      Earth_Radius => <-.GISMapTransform.Radius.value;
   };
};
