/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/gisdem.v#1 $
*/

APPS.SingleWindowApp GISDEMQuad<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows how GIS DEM data can be read into Express, then sampled using the GISDigitalElevation macro. The GISMap_Transform macro allows you to select some standard map projections to display the data, and the scale macro allows for a vertical exaggeration.";
      helpfile = "examples/examples_help.htm";
   };

   GIS_UI.GISDigitalElevation GISDigitalElevation<NEx=242.,NEy=44.> {
      IsNotEqual {
         coc {
            output = 0;
         };
      };
      UIfileDialog {
         filename = "$XP_PATH<0>/data/DEM/denver-e.dat";
         cancel = 1;
      };
      Ingest.do = 1;
   };
   GIS_UI.GISMapTransform GISMapTransform<NEx=253.,NEy=121.> {
      UIpanel<NEx=346.,NEy=118.>;
      Transform<NEx=13.,NEy=206.> {
         List {
            selectedItem = 2;
         };
         selectedText = "Cartesian";
      };
      BaseLat<NEx=179.,NEy=206.>;
      BaseLon<NEx=345.,NEy=206.>;
      Radius<NEx=13.,NEy=294.>;
      Offset<NEx=179.,NEy=294.>;
      UIlabel#1<NEx=345.,NEy=294.>;
      UIlabel#2<NEx=511.,NEy=294.>;
      UIlabel#3<NEx=677.,NEy=294.>;
      GISMeshProject<NEx=77.,NEy=22.> {
         in => <-.<-.GISDigitalElevation.GISDEM.demGrid;
      };
      MapObject<NEx=34.,NEy=470.>;
      MapObject#2<NEx=242.,NEy=470.>;
      MapObject#3<NEx=450.,NEy=470.>;
      MapObject#4<NEx=658.,NEy=470.>;
      UImod_panel<NEx=346.,NEy=30.>;
   };
   MODS.scale scale<NEx=319.,NEy=198.> {
      in_field => <-.GISMapTransform.GISMeshProject.out;
      ScaleParam {
         scale_z = 30.;
      };
      ScaleUI {
         scale_z_slider {
            max = 100.;
         };
      };
   };
   GEOMS.LegendVert LegendVert<NEx=198.,NEy=264.> {
      obj_in => <-.scale.out_obj;
      numIntervals = 5;
   };

   GDM.Uviewer3D Uviewer<NEx=462.,NEy=275.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.scale.out_obj,<-.<-.<-.LegendVert.GroupObject.obj};
            Xform {
               mat = {
                  5.41976e-005,0.,0.,0.,0.,5.41976e-005,0.,0.,0.,0.,5.41976e-005,
0.,0.,0.,0.,1.
               };
               xlate = {-1968.85,17.1859,
-2.30394};
            };
         };
         Lights {
            Lights = {
               {
                  type="BiDirectional"
               },,,};
         };
      };
      Scene_Editor {
         Light_Editor {
            GDlight_edit {
               type = "BiDirectional";
            };
            IUI {
               General {
                  IUI {
                     AllFrame {
                        y = 0;
                     };
                     CurrentLight {
                        y => 80;
                     };
                     LightType {
                        OPcmdList = {,,,
                           {
                              set=1
                           }};
                     };
                  };
               };
            };
         };
      };
   };
};
