/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/hdf5_1.v#1 $
*/

APPS.SingleWindowApp HDF5_MR_Head<NEdisplayMode="maximized",disabled => Templates.CONFIG.hdf5_kit_disabled,NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=352.,NEy=66.> {
      demo_text = "This example shows the HDF5 reader being used to read a large uniform field with node data. With very large datasets you can reduce the amount of data in memory at any one time by using the versions of crop and downsize integrated into the reader. HDF5 has large file support, so you can use the reader on multi-gigabyte data files.";
      helpfile = "examples/examples_help.htm";
   };

   HDF5.Rd_HDF5_Field Rd_HDF5_Field<NEx=66.,NEy=77.> {
      Rd_HDF5_Param {
         filename = "$XP_PATH<0>/data/hdf5/mr_head.h5";
         trigger = 1;
      };
   };
   MODS.bounds bounds<NEx=110.,NEy=231.> {
      in_field => <-.Rd_HDF5_Field.out_fld;
   };
   MODS.orthoslice orthoslice<NEx=297.,NEy=132.> {
      in_field => <-.Rd_HDF5_Field.out_fld;
      OrthoSliceParam {
         axis = 2;
      };
   };

   GDM.Uviewer3D Uviewer3D<NEx=363.,NEy=418.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,
               <-.<-.<-.orthoslice.out_obj};
            Xform {
               ocenter = {96.3001,113.4,113.4};
               dcenter = {3.00884,3.41907,3.46645};
               mat = {
                  0.0300906,-0.00114335,0.00529486,0.,0.00181247,0.030288,-0.00375998,
0.,-0.00510469,0.00401438,0.0298766,0.,0.,0.,0.,1.
               };
               xlate = {-3.00884,-3.41907,-3.46645};
            };
         };
      };
   };

   UI {
      shell {
         x = 20;
         y = 20;
      };
      Modules {
         IUI {
            optionList {
               selectedItem = 0;
            };
         };
      };
   };

};
