//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/dv_examp/hdf5_ex_cell.v#1 $

APPS.SingleWindowApp HDF5_Ex_Cells<NEdisplayMode="maximized",disabled => Templates.CONFIG.hdf5_kit_disabled,NEhelpFile="examples/examples_help.htm"> {

   UI {
      shell {
         x = 10;
         y = 10;
      };
      Modules {
         IUI {
            optionList {
               selectedItem = 0;
            };
         };
      };
   };

   UIsummaryPanel Summary_Panel<NEx=352.,NEy=66.> {
      UIlabel {
         label = "HDF5 Unstructured Field Example";
         height => UIdata.UIfonts[0].lineHeight;
      };
      demo_text = "This example shows the HDF5 reader being used to read an unstructured field consisting of 6 Quad cells with cell data. \n\nThe source code for the program used to create the HDF5 file can be found in the src/hdf5/examp directory.";
      helpfile = "examples/examples_help.htm";
   };

   HDF5.Rd_HDF5_Field Rd_HDF5_Field<NEx=77.,NEy=66.> {
      Rd_HDF5_Param {
         filename = "$XP_PATH<0>/data/hdf5/examp_cells.h5";
         trigger = 1;
      };
   };

   GDM.Uviewer3D Uviewer3D<NEx=253.,NEy=297.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.Rd_HDF5_Field.out_obj};
         };
      };
   };

};
