/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/hex2.v#1 $
*/

APPS.SingleWindowApp Hex2<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows how files can be read using the File Access Objects (read_hex2 macro) and how a hex mesh can be created using the hex2_mesh Mesh Mapper. Note the use of combine_mesh_data to add a node data to the field, and combine_mesh_cell_data to add cell data to the field. Several standard techniques are used to visualize the final field that is created.";
      helpfile = "examples/examples_help.htm";
      UItext.rows = 11;
   };

   UI {
      shell {
         x = 10;
         y = 100;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=286.,NEy=418.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.external_edges.out_obj,<-.<-.<-.isosurface.out_obj,
               <-.<-.<-.cut_plane.out_obj_cut};
            Xform {
               mat = {
                  0.197348,0.149449,-0.0621788,0.,-0.114011,0.0587386,-0.220677,
0.,-0.114902,0.198399,0.112172,0.,0.,0.,0.,1.
               };
               xlate = {-4.,-4.,-4.};
            };
         };
         View {
            View {
               trigger = 1;
            };
         };
         Lights {
            Lights = {
               {
                  type="BiDirectional"
               },,,};
         };
      };
   };
   macro read_hex2<NEx=275.,NEy=11.> {
      module rd_coord<data_import_module=1,NEx=77.,NEy=99.> {
         file FILE {
            name = "$XP_PATH<0>/data/ucd/hex2/hex_coord.dat";
         };
         macro UI {
            UImod_panel UImod_panel {
               title => name_of(<-.<-.<-);
               parent<NEportLevels={3,0}>;
            };
            UIlabel Filename {
               parent => <-.UImod_panel;
               y = 0;
               width = 200;
               alignment = "left";
            };
            UItext file_name {
               parent => <-.UImod_panel;
               y => ((<-.Filename.y + <-.Filename.height) + 5);
               text => <-.<-.FILE.name;
               width = 170;
               showLastPosition = 1;
            };
            UIbutton visible {
               parent => <-.UImod_panel;
               x => ((<-.file_name.x + <-.file_name.width) + 5);
               y => <-.file_name.y;
               width = 75;
               height => <-.file_name.height;
               label => "Browse...";
            };
            UIfileSB file_browser {
               GMOD.copy_on_change copy_on_change {
                  trigger => <-.<-.visible.do;
                  input => <-.<-.visible.do;
                  output => <-.visible;
               };
               title => "Filename";
               filename => <-.<-.FILE.name;
               searchPattern = "./*.dat";
               dirMaskCache = "$XP_PATH<0>/data/ucd/hex2/*.dat";
            };
         };
         float coord[] => cache(file_obj(.FILE,0,4,{1,1,1},0,1));
         float xy<NEportLevels={0,3},NEdisplayMode="open">[(array_size(.coord) / 3)][3] => .coord;
      };
      module rd_conn<data_import_module=1> {
         file FILE {
            name = "$XP_PATH<0>/data/ucd/hex2/hex_conn.dat";
         };
         macro UI {
            UImod_panel UImod_panel {
               title => name_of(<-.<-.<-);
               parent<NEportLevels={3,0}>;
            };
            UIlabel Filename {
               parent => <-.UImod_panel;
               y = 0;
               width = 200;
               alignment = "left";
            };
            UItext file_name {
               parent => <-.UImod_panel;
               y => ((<-.Filename.y + <-.Filename.height) + 5);
               text => <-.<-.FILE.name;
               width = 170;
               showLastPosition = 1;
            };
            UIbutton visible {
               parent => <-.UImod_panel;
               x => ((<-.file_name.x + <-.file_name.width) + 5);
               y => <-.file_name.y;
               width = 75;
               height => <-.file_name.height;
               label => "Browse...";
            };
            UIfileSB file_browser {
               GMOD.copy_on_change copy_on_change {
                  trigger => <-.<-.visible.do;
                  input => <-.<-.visible.do;
                  output => <-.visible;
               };
               title => "Filename";
               filename => <-.<-.FILE.name;
               searchPattern = "./*.dat";
               dirMaskCache = "$XP_PATH<0>/data/ucd/hex2/*.dat";
            };
         };
         int connectivity<NEportLevels={0,3}>[] => cache(file_obj(.FILE,0,3,{
                  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
               },0,1));
      };
      module rd_data<data_import_module=1> {
         file FILE {
            name = "$XP_PATH<0>/data/ucd/hex2/hex_data.dat";
         };
         macro UI {
            UImod_panel UImod_panel {
               title => name_of(<-.<-.<-);
               parent<NEportLevels={3,0}>;
            };
            UIlabel Filename {
               parent => <-.UImod_panel;
               y = 0;
               width = 200;
               alignment = "left";
            };
            UItext file_name {
               parent => <-.UImod_panel;
               y => ((<-.Filename.y + <-.Filename.height) + 5);
               text => <-.<-.FILE.name;
               width = 170;
               showLastPosition = 1;
            };
            UIbutton visible {
               parent => <-.UImod_panel;
               x => ((<-.file_name.x + <-.file_name.width) + 5);
               y => <-.file_name.y;
               width = 75;
               height => <-.file_name.height;
               label => "Browse...";
            };
            UIfileSB file_browser {
               GMOD.copy_on_change copy_on_change {
                  trigger => <-.<-.visible.do;
                  input => <-.<-.visible.do;
                  output => <-.visible;
               };
               title => "Filename";
               filename => <-.<-.FILE.name;
               searchPattern = "./*.dat";
               dirMaskCache = "$XP_PATH<0>/data/ucd/hex2/*.dat";
            };
         };
         float data<NEportLevels={0,3}>[] => cache(file_obj(.FILE,0,4,{1},0,1));
      };
      module rd_cell_data<data_import_module=1,NEx=396.,NEy=55.> {
         file FILE {
            name = "$XP_PATH<0>/data/ucd/hex2/hex_cdata.dat";
         };
         macro UI {
            UImod_panel UImod_panel {
               title => name_of(<-.<-.<-);
               parent<NEportLevels={3,0}>;
            };
            UIlabel Filename {
               parent => <-.UImod_panel;
               y = 0;
               width = 200;
               alignment = "left";
            };
            UItext file_name {
               parent => <-.UImod_panel;
               y => ((<-.Filename.y + <-.Filename.height) + 5);
               text => <-.<-.FILE.name;
               width = 170;
               showLastPosition = 1;
            };
            UIbutton visible {
               parent => <-.UImod_panel;
               x => ((<-.file_name.x + <-.file_name.width) + 5);
               y => <-.file_name.y;
               width = 75;
               height => <-.file_name.height;
               label => "Browse...";
            };
            UIfileSB file_browser {
               GMOD.copy_on_change copy_on_change {
                  trigger => <-.<-.visible.do;
                  input => <-.<-.visible.do;
                  output => <-.visible;
               };
               title => "Filename";
               filename => <-.<-.FILE.name;
               searchPattern = "./*.dat";
               dirMaskCache = "$XP_PATH<0>/data/ucd/hex2/*.dat";
            };
         };
         float data<NEportLevels={0,3},NEdisplayMode="open">[] => cache(file_obj(.FILE,0,4,{1},0,1));
      };
   };
   FLD_MAP.hex2_mesh hex2_mesh<NEx=187.,NEy=88.> {
      coord => <-.read_hex2.rd_coord.xy;
      connect => <-.read_hex2.rd_conn.connectivity;
   };
   FLD_MAP.node_scalar node_scalar<NEx=363.,NEy=88.> {
      in_data => <-.read_hex2.rd_data.data;
   };
   FLD_MAP.combine_mesh_data combine_mesh_data<NEx=187.,NEy=176.> {
      in_mesh => <-.hex2_mesh.out;
      in_nd => <-.node_scalar.out;
   };
   MODS.external_edges external_edges<NEx=198.,NEy=308.> {
      in_field => <-.combine_mesh_data.out;
      edge_angle = 2.83;
   };
   FLD_MAP.combine_mesh_cell_data combine_mesh_cell_data<NEx=374.,NEy=231.> {
      in_mesh => <-.combine_mesh_data.out;
      in_data => <-.read_hex2.rd_cell_data.data;
   };
   MODS.isosurface isosurface<NEx=396.,NEy=308.> {
      in_field => <-.combine_mesh_cell_data.out;
      IsoParam {
         iso_level => 731.76;
      };
      IsoUI {
         UIoptionBoxLabel {
            label_cmd {
               cmd[] = {
                  {
                     set=1,,,
                  }};
            };
         };
         UIoptionBoxLabel_cell {
            label_cmd {
               cmd[1] = {
                  {
                     active=1,
                  }};
            };
         };
      };
   };
   MODS.cut_plane cut_plane<NEx=583.,NEy=308.> {
      in_field => <-.combine_mesh_cell_data.out;
      plane {
         xform {
            xlate = {0.,0.,9.5};
            mat = {
               0.693649,0.262841,0.670646,0.,-0.357174,0.934032,0.00335772,0.,
-0.625522,-0.241867,0.74177,0.,0.,0.,0.,1.
            };
         };
      };
      CutUI {
         UIoptionBoxLabel {
            label_cmd {
               cmd[];
            };
         };
         UIoptionBoxLabel_cell {
            label_cmd {
               cmd[];
            };
         };
      };
   };
};
