/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/isol.v#1 $
*/

APPS.MultiWindowApp Isoline<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=320.,NEy=44.> {
      demo_text = "This example uses an external_faces macro to provide input for an isoline macro. the isoline macro generates isolines on the surface which can then be rendered by the viewer. Note the use of the external_edges macro to create the external edges object in the viewer.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEx=132.,NEy=44.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.external_faces external_faces<NEy=121.,NEx=55.> {
      in_field => Read_UCD.field;
   };
   MODS.isoline isoline<NEy=198.,NEx=55.> {
      in_field => external_faces.out_fld;
      IsoParam {
         ncontours = 18;
         level_min => 1.57;
         level_max => 4.82;
      };
   };
   MODS.external_edges external_edges<NEy=121.,NEx=253.> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=330.,NEx=187.> {
      Scene {
         Top {
            child_objs => {isoline.out_obj,
               external_edges.out_obj};
            Xform {
               mat = {
                  -0.568041,0.491131,0.608429,0.,0.380365,0.830619,-0.31537,0.,
-0.683166,0.0540957,-0.681485,0.,0.,0.,0.,1.
               };
               xlate = {-1.1513,-2.16129,
-1.46212};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
