/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/isonest_2.v#1 $
*/

APPS.MultiWindowApp IsoNest_Unstr <NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows a set of nested isosurface shells.  Each isosurface shell is transparent, giving a total effect that is a bit like volume rendering.  Unlike volme rendering, this technique can be used on almost any type of input field and this particular example uses an unstructured field.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };

   MODS.external_edges external_edges {
      in_field => <-.Read_UCD.field;
   };

   MODS.isosurface_nest isosurface_nest {
      in_field => <-.Read_UCD.field;
      isonest_params {
         num_levels = 6;
         min = 1.10;
      };
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {<-.<-.<-.external_edges.out_obj,
                           <-.<-.<-.isosurface_nest.obj };
         };
         Lights {
            LightXform = {
               {mat=
                  {
                     1.36416,0.392224,-1.1742,0.,0.890771,0.902386,1.33632,0.,
0.859709,-1.55736,0.478582,0.,0.,0.,0.,1.
                  },},
               ,,};
         };
         Camera {
            Camera {
               perspec = 1;
               front = 1.;
            };
         };
      };
   };

};
