/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/isop.v#1 $
*/

APPS.MultiWindowApp Iso_Probe<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "Iso_Probe shows the use of the iso_probe macro. This macro will generate an isosurface at a picked probe point location. You can make a selection on the slice by using <CRTL>LMB. Note the use of the Cross3D macro to provide the geometry for the picked point (probe) location.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=33.,NEx=154.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   GEOMS.Cross3D Cross3D<NEy=242.,NEx=352.>;
   GEOMS.FPlane FPlane<NEy=110.,NEx=220.> {
      in => Read_UCD.field;
   };
   MODS.slice slice<NEx=88.,NEy=242.> {
      in_field => Read_UCD.field;
      in_plane => FPlane.out_fld;
   };
   MODS.external_edges external_edges<NEy=110.,NEx=407.> {
      in_field => Read_UCD.field;
   };
   MODS.iso_probe iso_probe<NEy=352.,NEx=308.> {
      in_field => Read_UCD.field;
      in_glyph => Cross3D.out_fld;
      in_pick => Uviewer3D.Scene.View.View.picked_obj;
   };
   GDM.Uviewer3D Uviewer3D<NEy=429.,NEx=220.> {
      Scene {
         Top {
            child_objs => {slice.out_obj,
               external_edges.out_obj,iso_probe.out_obj,iso_probe.out_obj1};
            Xform {
               mat = {
                  -0.839674,0.456256,0.305527,0.,0.285313,0.839479,-0.46951,0.,
-0.469161,-0.306061,-0.832335,0.,0.,0.,0.,1.
               };
               xlate = {0.358712,-2.3422,
-1.93344};
            };
         };
      };
   };
};
