/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/isos.v#1 $
*/

APPS.MultiWindowApp Isosurface<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows how to use the isosurface macro in a simple network. An isosurface is a surface of constant value, created within a 2D or 3D dataset. The bluntfin data is read in using Read_UCD and the reader's output field is connected to the isosurface macro.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=33.,NEx=187.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.isosurface isosurface<NEy=143.,NEx=220.> {
      in_field => Read_UCD.field;
      IsoParam {
          iso_level = 1.74;
      };
   };
   GEOMS.Axis3D Axis3D<NEy=143.,NEx=385.> {
      in_field => Read_UCD.field;
   };
   MODS.external_edges external_edges<NEy=143.,NEx=22.> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=297.,NEx=176.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               isosurface.out_obj,external_edges.out_obj};
            Xform {
               mat = {
                  0.587182,-0.175299,0.644766,0.,-0.0486038,0.844875,0.273967,
0.,-0.666401,-0.21608,0.548137,0.,0.,0.,0.,1.
               };
               xlate = {-0.847957,-1.48429,-0.81961};
            };
         };
      };
   };
};
