/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/isotrc.v#1 $
*/

APPS.MultiWindowApp Iso_Trace<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example demonstrates the isosurface_trace macro. This macro creates a local isosurface at a probe point. You make a selection in the 2D slice view by using <CTRL>LMB. A cross will be rendered at the picked position and a local isosurface will be drawn in the 3D viewer.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=33,NEx=440> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
   };
   MODS.orthoslice orthoslice<NEy=77,NEx=297> {
      in_field => Read_Field.field;
   };
   MODS.reset_xform reset_xform<NEy=176,NEx=242> {
      in_field => orthoslice.out_fld;
   };
   GEOMS.Cross2D Cross2D<NEx=77.,NEy=88.>;
   MODS.probe probe<NEx=143,NEy=242> {
      in_field => reset_xform.out_fld;
      in_glyph => Cross2D.out_fld;
      in_pick => <-.Uviewer3D.Scene.View.View.picked_obj;
   };
   MODS.set_xform set_xform<NEy=264,NEx=495> {
      in_field1 => probe.out_fld;
      in_field2 => orthoslice.out_fld;
   };
   MODS.bounds bounds<NEy=77,NEx=649> {
      in_field => Read_Field.field;
   };
   MODS.isosurface_trace isosurface_trace<NEy=352,NEx=495> {
      in_field => Read_Field.field;
      probe => set_xform.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=407,NEx=275> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.reset_xform.out_obj,<-.<-.<-.probe.out_obj};
         };
         Lights {
            Lights = {
               {
                  type="BiDirectional"
               },,,};
         };
      };
      Scene_Selector {
         input_views => {<-.Scene.View.View,
            <-.Scene#1.View.View};
      };
      GDM.Uscene3D Scene#1 {
         Top {
            child_objs<NEportLevels={4,1}> => {
               <-.<-.<-.orthoslice.out_obj,<-.<-.<-.isosurface_trace.out_obj,
               <-.<-.<-.bounds.out_obj};
            Xform {
               mat = {
                  0.0745629,0.0179002,-0.0610185,0.,0.0262469,0.0769868,0.0546575,
0.,0.0579204,-0.0579304,0.0537829,0.,0.,0.,0.,1.
               };
               xlate = {-5.,-5.,-5.};
            };
         };
         Lights {
            Lights = {
               {
                  type=3
               },,,};
         };
      };
   };
};
