/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/isov.v#1 $
*/

APPS.MultiWindowApp Isovolume<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "The isovolume macro used in this example is similar to isosurface. However, isovolume cuts the input field using the isosurface.  The end result is that you get a volume output rather than a surface of constant data value. Note that external_faces is used to cut down the objects that need to be rendered.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=33.,NEx=176.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.isovolume isovolume<NEx=275.,NEy=132.> {
      in_field => Read_UCD.field;
      IsoVolParam {
         iso_component = 0;
         iso_level => 1.74;
         map_component = {2};
         above = 1;
      };
   };
   MODS.external_faces external_faces<NEy=242.,NEx=297.> {
      in_field => isovolume.out_fld;
   };
   MODS.external_edges external_edges<NEy=132.,NEx=99.> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=363.,NEx=165.> {
      Scene {
         Top {
            child_objs => {
               external_faces.out_obj,external_edges.out_obj};
            Xform {
               mat = {
                  0.753254,0.0128765,0.554879,0.,-0.184553,0.887988,0.229926,
0.,-0.523447,-0.29455,0.71742,0.,0.,0.,0.,1.
               };
               xlate = {-1.1513,-2.16129,-1.46212};
            };
         };
      };
   };
};
