/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/isov2uni.v#1 $
*/

APPS.MultiWindowApp IsoVolume_2D<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "IsoVolume_2D demonstrates the use of the isovolume macro. The hydrogen dataset is read in using Read_Field and then a 2D orthoslice is created using Orthoslice. The isovolume macro is then used on the output field from the orthoslice macro.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=33.,NEx=77.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds<NEy=121.,NEx=264.> {
      in_field => Read_Field.field;
   };
   MODS.orthoslice orthoslice<NEy=121.,NEx=66.> {
      in_field => Read_Field.field;
      OrthoSliceParam {
         axis = 2;
      };
   };
   MODS.isovolume isovolume<NEx=66.,NEy=198.> {
      in_field => orthoslice.out_fld;
      IsoVolParam {
         iso_level => 122.83;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEy=341.,NEx=209.> {
      Scene {
         Top {
            child_objs => {bounds.out_obj,
               isovolume.out_obj};
            Xform {
               mat = {
                  0.0777434,0.00485683,0.0618645,0.,-0.0235911,0.0940351,0.0222638,
0.,-0.0573956,-0.0320723,0.0746454,0.,0.,0.,0.,1.
               };
               xlate = {-5.,-5.,-5.};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
