/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/m1_ucd.v#1 $
*/

APPS.MultiWindowApp Multistep_UCD<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text => "This example shows reading a time-dependent (multi-step) UCD file. Only the node data varies over time - the shift in the field's position is provided by the offset macro. Also note the use of the set_minmax macro to ensure that the colormap is the same for all of the time steps.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEx=527.,NEy=22.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/yoke.inp";
      };
   };
   MODS.offset offset<NEx=472.,NEy=88.> {
      in_field => <-.Read_UCD.field;
   };
   MODS.magnitude magnitude<NEx=472.,NEy=154.> {
      in_field => <-.offset.out_fld;
      MagParam {
         component = 2;
      };
   };
   MODS.set_minmax set_minmax<NEx=472.,NEy=220.> {
      in_field => <-.magnitude.out_fld;
      SetMinmaxParam {
         min => 0.0;
         max => 145.0;
      };
   };
   MODS.external_faces external_faces<NEx=472.,NEy=275.> {
      in_field => <-.set_minmax.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEx=550,NEy=400> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.Read_UCD.title_obj,<-.<-.<-.external_faces.out_obj};
            Modes {
               mode = {0,2,0,0,0};
            };
            Xform {
               dcenter = {2.82602,-2.38854,4.54639};
               mat = {
                  0.00736294,0.107482,-0.135018,0.,0.0324433,0.131869,0.106745,
0.,0.169499,-0.0299097,-0.0145667,0.,0.,0.,0.,1.
               };
               xlate = {-3.90188,0.595245,-1.04082};
            };
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultWidth = 417;
                        defaultHeight = 448;
                        defaultX = 544;
                        defaultY = 355;
                     };
                  };
               };
            };
            View {
               trigger = 1;
            };
         };
         Camera {
            Camera {
               auto_norm = "None";
               perspec = 1;
               front = 1.;
            };
         };
      };
      Scene_Editor {
         Object_Editor {
            GDmodes_edit {
               lines = "Regular";
            };
         };
         Camera_Editor {
            GDcamera_edit {
               front = 1.;
            };
         };
      };
   };
};
