/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/mirr_scl.v#1 $
*/

APPS.MultiWindowApp Mirror_Scale<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=350.,NEy=55.> {
      demo_text = "This example shows the use and behaviour of the mirror and scale macros. mirror will create the mirror image of an unstructured mesh. scale allows you to apply orthogonal scaling parameters to an input field.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=44.,NEx=143.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.downsize downsize<NEy=121.,NEx=143.> {
      in_field => Read_Field.field;
   };
   MODS.isosurface isosurface<NEy=176.,NEx=66.> {
      in_field => downsize.out_fld;
   };
   MODS.mirror mirror<NEy=253.,NEx=11.> {
      in_field => isosurface.out_fld;
      MirrorParam {
         x_axis = 1;
      };
   };
   MODS.scale scale<NEy=253.,NEx=198.> {
      in_field => isosurface.out_fld;
      ScaleParam {
         scale_x = 3.;
      };
   };
   MODS.bounds bounds<NEx=385.,NEy=187.> {
      in_field => <-.downsize.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=374.,NEx=286.> {
      Scene {
         Top {
            child_objs => {mirror.out_obj,
               scale.out_obj,<-.<-.<-.bounds.out_obj};
            Xform {
               mat = {
                  0.0374524,-0.0312035,0.0214343,0.,-0.00492473,0.0258792,0.0462794,
0.,-0.0375345,-0.0345308,0.0153153,0.,0.,0.,0.,1.
               };
               xlate = {-2.5,-1.30743,-1.33824};
            };
         };
      };
   };
};
