/*
        This file is under Perforce control
        $Id: //depot/express/fcs70/v/dv_examp/nc_sst.v#1 $
*/

APPS.SingleWindowApp NetCDF_SeaSurfaceTemps<NEdisplayMode="maximized",disabled => Templates.CONFIG.netcdf_kit_disabled,NEhelpFile="examples/examples_help.htm"> {

   // Get this dataset from
   // ftp.unidata.ucar.edu:/pub/netcdf/sample_data/sst-t.nc

   string Credits<NEx=30.,NEy=30.,NEwidth=350.,NEheight=80.,NEdisplayMode="open"> = "Sample data from ftp.unidata.ucar.edu";

   UIsummaryPanel Summary_Panel {
      UIlabel.label = "AVS/Express netCDF Example";
      demo_text = "This example demonstrates importing netCDF sea surface temperature data.\n\nThe dataset is straight from the Unidata FTP site, so this example shows that it can be very easy to import netCDF data.";
      helpfile = "examples/examples_help.htm";
   };

   NETCDF.Read_Field Read_netCDF_Field<NEx=140.,NEy=200.> {
       Read_NetCDF_Param {
         filename = "$XP_PATH<0>/data/netCDF/sst-t.nc";
         selectedVariables = {1};
         timeEnable = 1;
         timeStep = 0;
         trigger = 1;
      };
   };

   GDM.Uviewer3D Uviewer3D<NEx=200.,NEy=340.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.Read_netCDF_Field.out_obj};
         };
      };
   };
};
