/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/nulldt.v#1 $
*/

APPS.MultiWindowApp Null_Data<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20.> {
      demo_text = "Null_Data shows the use of the set_null macro. In AVS/Express any node or cell data can have a null value associated with it, and set_null simplifies the application of a null value. This example also shows the use of an alternate object. This is the object that is rendered when an object is moved or rotated in the viewer. If you select Editors->Object from the menubar then you will see that the Enable toggle is on for Alternate Object. Select the different objects on the viewer using <CTRL>LMB, or by using the Select Object button in the lower right hand corner of the UI (below).";
      helpfile = "examples/examples_help.htm";
      UItext {
      	 rows = 15;
      };
   };

   MODS.Read_Field Read_Field<NEy=55,NEx=330> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/turbine.fld";
      };
   };
   MODS.downsize downsize<NEx=484,NEy=110> {
      in_field => <-.Read_Field.field;
      DownsizeParam {
         factor2 = 2.;
      };
   };
   MODS.bounds bounds<NEy=187,NEx=484> {
      in_field => <-.downsize.out_fld;
      BoundsParam {
         edges = 1;
         imax = 1;
         jmin = 1;
         jmax = 1;
         kmin = 1;
         data = 1;
      };
   };
   MODS.set_null set_null<NEx=231,NEy=132> {
      in_field => Read_Field.field;
   };
   MODS.orthoslice orthoslice<NEy=220,NEx=319> {
      in_field => set_null.out_fld;
      OrthoSliceParam {
         axis = 2;
      };
      obj {
         Obj {
            use_altobj = 1;
         };
         AltObject {
            Obj {
               visible = 0;
            };
         };
      };
   };
   MODS.isosurface isosurface<NEx=165,NEy=220> {
      in_field => <-.set_null.out_fld;
      obj {
         Obj {
            use_altobj = 1;
         };
         AltObject {
            Obj {
               visible = 0;
            };
         };
      };
   };
   GDM.Uviewer3D Uviewer3D<NEy=319,NEx=319> {
      Scene {
         Top {
            child_objs => {bounds.out_obj,
               orthoslice.out_obj,isosurface.out_obj};
            Xform {
               mat = {
                  0.12458,0.0584145,-0.0785896,0.,-0.0349096,0.145313,0.0526704,
0.,0.0914873,-0.0240957,0.127115,0.,0.,0.,0.,1.
               };
               xlate = {-1.80497,-1.90851,-0.595606};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
