/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/offset.v#1 $
*/

APPS.MultiWindowApp Offset<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=330.,NEy=22.> {
      demo_text = "This example demosntrates the offset macro. This \"physically\" deforms a mesh by the values of a 1, 2 or 3 vector component located at each node. That is, the coordinates of the mesh are changed. Note the use of combine_vect to create the 3 vector component with which to transform the mesh.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=22.,NEx=110.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.combine_vect combine_vect<NEy=110.,NEx=275.> {
      in_field => Read_UCD.field;
      CombineVectParam {
         components = {1,2,3};
      };
   };
   MODS.offset offset<NEy=176.,NEx=275.> {
      in_field => combine_vect.out_fld;
      OffsetParam {
         scale = 0.47;
      };
   };
   MODS.external_edges external_edges<NEy=110.,NEx=44.> {
      in_field => Read_UCD.field;
   };
   MODS.external_faces external_faces<NEy=253.,NEx=275.> {
      in_field => offset.out_fld;
   };
   MODS.magnitude magnitude<NEx=286.,NEy=319.> {
      in_field => <-.external_faces.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=396.,NEx=77.> {
      Scene {
         Top {
            child_objs => {
               external_edges.out_obj,<-.<-.<-.magnitude.out_obj};
            Xform {
               mat = {
                  0.498745,-0.362054,0.413997,0.,0.0719836,0.59704,0.435412,0.,
-0.545248,-0.252354,0.436172,0.,0.,0.,0.,1.
               };
               xlate = {-1.03764,-1.69769,-0.300872};
            };
         };
      };
   };
};
