/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/orth.v#1 $
*/

APPS.MultiWindowApp Orthoslice<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=15.,NEy=11.> {
      demo_text = "This shows a simple application of the orthoslice macro. The 3D hydrogen dataset is read in using the Read_Field macro and orthoslice is used to select a 2D slice from the data. The Axis3D and bounds macros help show the extent of the original 3D dataset. If you require non-orthogonal slices you may use the Arbitrary_Slicer macro, found in Libraries->Accessories->Utility_Modules->Viz_Macros->Arbitrary_Slicer.";
      helpfile = "examples/examples_help.htm";
      UItext {
      	 rows = 12;
      };
   };

   MODS.Read_Field Read_Field<NEy=11.,NEx=176.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds<NEy=132.,NEx=418.> {
      in_field => Read_Field.field;
   };
   MODS.orthoslice orthoslice<NEy=132.,NEx=231.> {
      in_field => Read_Field.field;
      OrthoSliceParam {
         axis = 2;
      };
   };
   GEOMS.Axis3D Axis3D<NEy=132.,NEx=33.> {
      in_field => Read_Field.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=286.,NEx=253.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               bounds.out_obj,orthoslice.out_obj};
            Xform {
               mat = {
                  0.0725853,0.0100122,0.0579557,0.,-0.0376367,0.0786484,0.0335502,
0.,-0.0451949,-0.0494155,0.0651402,0.,0.,0.,0.,1.
               };
               xlate = {-3.99421,-3.96521,-4.36559};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
