/*
                        Copyright (c) 1999 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/v/dv_examp/reduct1.v#1 $
*/

APPS.SingleWindowApp Reduct_AltObject<NEdisplayMode="maximized",disabled => Templates.CONFIG.reduct_kit_disabled,NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=10.> {
      demo_text = "This example shows the use of the data_surface_reduction macro, applying its output to be used as an alternate object for the main isosurface that is rendered in the viewer. This is a useful approach for large volumes of data as the amount of geometry that the renderer has to deal with when an object is manipulated is reduced. Note that standard macro DataObject has an alternate object field input. You can see that the alternate object is enabled by selecting Editors->Object from the menubar. To select the DataObject object in the viewer, use <CTRL>LMB. When you do this you will see that the Enable toggle is selected for the Alternate Object.";
      helpfile = "examples/examples_help.htm";
      UItext {
      	 rows = 16;
      };
      
   };

   UI {
      shell {
         x = 50;
         y = 100;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=99.,NEy=319.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.DataObject.obj};
            Xform {
               mat = {
                  0.141058,0.,0.,0.,0.,0.141058,0.,0.,0.,0.,0.141058,0.,
0.,0.,0.,1.
               };
            };
         };
         View {
            View {
               trigger = 1;
            };
         };
      };
      Scene_Editor {
         Object_Editor {
            GDmodes_edit {
               edit_alt_modes = 1;
               points = "Inherit";
               lines = "Inherit";
               surf = "Inherit";
               volume = "Inherit";
               bounds = "Inherit";
            };
            IUI {
               General {
                  IUI {
                     AltSpace {
                        OPcmdList = {
                           {
                              set=1,,,,,,,,,,,,,,,,,,,,
                           },
                           };
                     };
                     TransformMode {
                        OPcmdList = {
                           {
                              set=1,,,,,,,,,,,,,,,,,,,,
                           },
                           ,,};
                     };
                  };
               };
               Modes {
                  IUI {
                     panel {
                        visible = 1;
                     };
                     EditAltModes {
                        OPcmdList = {,
                           {
                              set=1,,,,,,,,,,,,,,,,,,,,
                           }};
                     };
                     Point {
                        OPcmdList = {
                           ,
                           {
                              set=1,,,,,,,,,,,,,,,,,,,,
                           },
                           ,,,,
                        };
                     };
                     Line {
                        OPcmdList = {
                           ,
                           {
                              set=1,,,,,,,,,,,,,,,,,,,,
                           },
                           ,,,
                        };
                     };
                     Surface {
                        OPcmdList = {
                           ,
                           {
                              set=1,,,,,,,,,,,,,,,,,,,,
                           },
                           ,,,
                        };
                     };
                     Volume {
                        OPcmdList = {,
                           {
                              set=1,,,,,,,,,,,,,,,,,,,,
                           },
                           ,};
                     };
                     Bounds {
                        OPcmdList = {,,
                           {
                              set=1,,,,,,,,,,,,,,,,,,,,
                           }};
                     };
                     Normals {
                        OPcmdList = {
                           {
                              set=1,,,,,,,,,,,,,,,,,,,,
                           },
                           ,};
                     };
                  };
               };
            };
         };
      };
   };
   MODS.Read_Field Read_Field<NEx=99.,NEy=55.> {
      read_field_ui {
         file_browser {
            dirMaskCache = "$XP_PATH<0>/data/field/*.fld";
         };
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
   };
   MODS.isosurface isosurface<NEx=99.,NEy=110.> {
      in_field => <-.Read_Field.field;
   };
   RDCT.data_surface_reduction data_surface_reduction<NEx=176.,NEy=187.> {
      in => <-.isosurface.out_fld;
      DataSurfRedParams {
         Mode = "Dynamic";
      };
   };
   GDM.DataObject DataObject<NEx=99.,NEy=242.> {
      in => <-.isosurface.out_fld;
      AltObject {
         alt_in<NEportLevels={3,1}> => <-.<-.data_surface_reduction.out;
         AltModes {
            mode = {0,0,0,0,0};
         };
      };
      Obj {
         use_altobj = 1;
         xform_mode = "Parent";
      };
   };
};
