/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/rib_plot.v#1 $
*/

APPS.MultiWindowApp Ribbon_Plot<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEy=11.,NEx=300.> {
      demo_text = "Ribbon_Plot demonstrates the use of the ribbons_plot macro. It is one of several methods to give a 3D look to 2D data. Note the use of downsize to preprocess the data into a reduced data volume 2D slice. The ribbons_plot macro then creates a ribbon visualization based upon this data.";
      helpfile = "examples/examples_help.htm";
   };

   HDF5.Rd_HDF5_Field Rd_HDF5_Field<NEy=11.,NEx=132.> {
      Rd_HDF5_Param {
         filename = "$XP_PATH<0>/data/hdf5/hydrogen2d.h5";
         trigger = 1;
      };
   };
   MODS.downsize downsize<NEy=66.,NEx=132.> {
      in_field => <-.Rd_HDF5_Field.out_fld;
      DownsizeParam {
         factor0 = 6.;
         factor1 = 6.;
         factor2 = 5.;
      };
   };
   MODS.ribbons_plot ribbons_plot<NEx=132.,NEy=187.> {
      in_field => downsize.out_fld;
      SurfRibParam {
         scale = 0.1;
      };
   };
   GEOMS.Axis3D Axis3D<NEy=253.,NEx=88.> {
      in_field => ribbons_plot.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=352.,NEx=275.> {
      Scene {
         Top {
            child_objs => {Axis3D.out_obj,
               ribbons_plot.out_obj};
            Xform {
               mat = {
                  0.0675765,-0.0210737,0.0827865,0.,0.0633502,0.0831775,-0.030538,
0.,-0.0573103,0.0670948,0.0638603,0.,0.,0.,0.,1.
               };
               xlate = {-3.66481,-3.95819,-5.86242};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
