/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/sct_unif.v#1 $
*/

APPS.MultiWindowApp Scat_to_Unif<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This examples shows how to use the scat_to_unif macro. The scat_to_unif macro converts a scattered grid into uniform field. Note that external_edges uses the original UCD dataset, while slice uses the new uniform field and is thus rectangular in shape.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=88,NEx=374> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   GEOMS.FPlane FPlane<NEy=220,NEx=550> {
      in => Read_UCD.field;
   };
   MODS.scat_to_unif scat_to_unif<NEy=220,NEx=385> {
      in_field => Read_UCD.field;
   };
   MODS.slice slice<NEy=297,NEx=429> {
      in_field => scat_to_unif.out_fld;
      in_plane => FPlane.out_fld;
   };
   MODS.external_edges external_edges<NEy=220,NEx=220> {
      in_field => Read_UCD.field;
   };
   GDM.Uviewer3D Uviewer3D<NEy=374,NEx=363> {
      Scene {
         Top {
            child_objs => {slice.out_obj,
               external_edges.out_obj};
            Xform {
               mat = {
                  0.745811,-0.212213,0.523621,0.,-0.0851752,0.815004,0.451621,
0.,-0.558533,-0.407655,0.630322,0.,0.,0.,0.,1.
               };
               xlate = {-1.1513,-2.16129,-1.46212};
            };
         };
      };
   };
};
