/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/slc_txt2.v#1 $
*/

APPS.MultiWindowApp Slice_Texture2D<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=100.> {
      demo_text = "This example shows how to use the slice_texture2D macro. The macro uses a 2D slice plane (provided by the FPlane macro) to extract a slice from a 3D uniform field. It then 2D texture maps this slice plane with colors representing the data values of the first component (which must be scalar) on the extracted slice.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=22.,NEx=110.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds<NEy=132.,NEx=363.> {
      in_field => Read_Field.field;
   };
   DATAS.colormap colormap<NEy=209.,NEx=297.>;
   GEOMS.FPlane FPlane<NEy=132.,NEx=176.> {
      in => Read_Field.field;
   };
   MODS.slice_texture2D slice_texture2D<NEy=264.,NEx=110.> {
      texture_map => colormap;
      in_field => Read_Field.field;
      in_plane => FPlane.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=385.,NEx=374.> {
      Scene {
         Top {
            child_objs => {
               slice_texture2D.out_obj,bounds.out_obj};
            Xform {
               mat = {
                  0.0671598,0.012786,0.0645044,0.,-0.0376694,0.0830532,0.0227575,
0.,-0.0539009,-0.0421119,0.0644672,0.,0.,0.,0.,1.
               };
               xlate = {-5.,-5.,-5.};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
