/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/slc_txt3.v#1 $
*/

APPS.MultiWindowApp Slice_Texture3D<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=100.> {
      demo_text = "This example shows how to use the slice_texture3D macro. The macro uses a slicing object to extract a plane of data (provided by the FPlane) from a 3D uniform field. It then 3D texture maps the surface of this plane with colors representing the data values of the first component (which must be scalar) on the extracted surface.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=22.,NEx=132.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds<NEy=110.,NEx=385.> {
      in_field => Read_Field.field;
   };
   DATAS.colormap colormap<NEy=176.,NEx=286.>;
   GEOMS.FPlane FPlane<NEy=110.,NEx=198.> {
      in => Read_Field.field;
   };
   MODS.slice_texture3D slice_texture3D<NEy=231.,NEx=110.> {
      texture_map => colormap;
      in_field => Read_Field.field;
      in_plane => FPlane.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=363.,NEx=253.> {
      Scene {
         Top {
            child_objs => {
               slice_texture3D.out_obj,bounds.out_obj};
            Xform {
               mat = {
                  0.102163,0.00266858,0.0407922,0.,-0.022316,-0.0883588,0.06167,
0.,0.034251,-0.065529,-0.081494,0.,0.,0.,0.,1.
               };
               xlate = {-3.59409,4.76341,-0.660495};
            };
         };
         View {
            View {
               renderer => 0;
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
         View_Editor {
            GDview_edit {
               renderer = 0;
            };
         };
      };
   };
};
