/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/splot.v#1 $
*/

APPS.MultiWindowApp Surf_plot<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=300.,NEy=22.> {
      demo_text = "Surf_Plot shows how to use the surf_plot macro. Note the use of the FPlane and slice macros to set up the input for the surf_plot macro. The surf_plot macro will create a surface from a 2D field with a node data associated with it. It is possible to scale the height of the surface produced.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEy=22.,NEx=99.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   GEOMS.FPlane FPlane<NEy=132.,NEx=165.> {
      in => Read_Field.field;
   };
   MODS.bounds bounds<NEy=132.,NEx=341.> {
      in_field => Read_Field.field;
   };
   MODS.slice slice<NEy=198.,NEx=77.> {
      in_field => Read_Field.field;
      in_plane => FPlane.out_fld;
   };
   MODS.surf_plot surf_plot<NEy=286.,NEx=77.> {
      in_field => slice.out_fld;
      SurfPlotParam {
         scale = 0.05;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEy=418.,NEx=319.> {
      Scene {
         Top {
            child_objs => {bounds.out_obj,
               surf_plot.out_obj};
            Xform {
               mat = {
                  0.0822402,-0.00423967,0.0540786,0.,0.0353195,0.07873,-0.0475399,
0.,-0.0411704,0.0590723,0.0672413,0.,0.,0.,0.,1.
               };
               xlate = {-5.,-5.,-5.};
            };
         };
      };
      Scene_Editor {
         Track_Editor {
            RNC {
               Normalize {
                  do = 1;
               };
            };
         };
      };
   };
};
