//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/dv_examp/text_columns_1.v#1 $

APPS.SingleWindowApp Text_Columns<NEdisplayMode="maximized", disabled => Templates.CONFIG.ag_kit_disabled, NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows the Text Column reader being used to read a complex text data file. The columns do not all have the same data type and some columns are skipped by the reader. Use the Text Grid reader when all the columns in the data file can be treated the same. Use the Text Column reader when you need to customize the treatment of individual columns.";
#ifdef MSDOS
      UItext.rows = 10;
#else
      UItext.rows = 12;
#endif
      helpfile = "examples/examples_help.htm";
   };

   UI {
      shell {
         x = 10;
         y = 10;
      };
   };
   MODS.Read_Text_Columns Rd_Txt_Columns<NEx=261.,NEy=23.> {
      param {
         filename = "$XP_PATH<0>/data/misc/gripacid1.txt";
         delim_ind = 1;
         header = 1;
         skip_lines = 83;
         index_column = 1;
         init_file = 0;
         columns = {
            {name="Depth (m)",type=4,use=1,null_value=0.},
            {name="Age (yr BP)",type=2,use=1,null_value=0.},
            {name="Length (yrs)",type=4,use=1,null_value=0.},
            {name="total",type=4,use=1,null_value=0.},
            {name="background",type=4,use=0,null_value=0.},
            {name="diff.",type=4,use=0,null_value=0.},
            {name="peak",type=4,use=0,null_value=0.},
            {name="deposition",type=2,use=1,null_value=0.},
            {name="magnitude",type=2,use=1,null_value=0.}
         };
         ncol = 9;
      };
   };
   MODS.table_to_uniform_field Table_to_uniform_field<NEx=251.,NEy=98.> {
      columns => <-.Rd_Txt_Columns.table;
      xyz_select {
         xyz_set = {1,0,0};
         xyz_axis = {9,0,0};
      };
      data_select {
         data = {1,2,3,4,5,6,7,8,9,10};
      };
   };
   FLD_MAP.extract_data_array Extract_data_array<NEx=261.,NEy=173.> {
      in => <-.Table_to_uniform_field.out_fld;
      comp = 8;
   };
   macro makeGraph<NEx=261.,NEy=248.> {
      AGHLM.GraphLegend GraphLegend {
         AGGraphLegend {
            graphs => {<-.<-.Graph.output};
         };
         LegendUI<instanced=0>;
         Legend_params {
            Label_Height = 3.;
            Title = "Legend";
            Title_Height = 4.5;
         };
      };
      AGHLM.GraphViewport GraphViewport {
         AGGraphViewportObj {
            graphViewport {
               children => {
                  <-.<-.<-.GraphWorld.out,<-.<-.<-.GraphLegend.obj};
            };
         };
         Viewport_params {
            Fill_Color = 10;
         };
      };
      AGHLM.GraphWorld GraphWorld {
         AGCombineGraphWorldInput {
            input1 => {<-.<-.Graph.output};
            input2 => <-.<-.XYAxis.mlink;
         };
      };
      AGHLM.XYAxis XYAxis {
         Y_Axis_params {
            Y_Axis_text => <-.<-.<-.Extract_data_array.label;
            text_height = 4.;
            label_height = 2.;
            Minor_tick_color = 2;
         };
         X_Axis_params<NEx=132.,NEy=341.> {
            label_height = 2.;
            text_height = 4.;
            X_Axis_text => <-.<-.<-.Table_to_uniform_field.x_name;
         };
      };
      AGHLM.Graph Graph {
         AGGraph {
            valuesY<NEportLevels={4,0}> => <-.<-.<-.Extract_data_array.data;
         };
         Graph_params {
            Graph_Name => <-.<-.<-.Extract_data_array.label;
            line_color = 4;
         };
      };
   };
   GDM.Uviewer2D Uviewer2D<NEx=261.,NEy=323.> {
      Scene {
         Top {
            child_objs => {<-.<-.<-.makeGraph.GraphViewport.obj};
         };
         Camera {
            Camera {
               norm_scale = 0.6;
            };
            CameraXform<NEx=266.,NEy=89.>;
         };
      };
   };
};
