//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/dv_examp/text_grid_1.v#1 $

APPS.SingleWindowApp Text_Grid<NEdisplayMode="maximized",
                               NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel { 
      demo_text = "This example shows the Text Grid reader being used to read a simple text data file representitive of what you would get if you exported a spreadsheet as a tab delimited text file. Use the Text Grid reader when all the columns in the data file can be treated the same.  Use the Text Column reader when you need to customize the treatment of individual columns.";
      helpfile = "examples/examples_help.htm";
   };

   UI {
      shell {
         x = 10;
         y = 10;
      };
   };
   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.Axis2D.out_obj,
               <-.<-.<-.city_plot.out_obj};
            Xform {
               mat = {
                  0.619002,0.0592229,0.100648,0.,0.000481578,0.541608,-0.321653,
0.,-0.116778,0.316154,0.532175,0.,0.,0.,0.,1.
               };
               xlate = {-0.724409,-2.29921,-0.566929};
            };
         };
      };
   };
   MODS.Read_Text_Grid Rd_Txt_Grid {
      param {
         filename = "$XP_PATH<0>/data/misc/grid_1.txt";
         col_header = 1;
         row_header = 1;
      };
      DVgrid_read {
         do = 1;
      };
   };
   GEOMS.Axis2D Axis2D<NExOffset=66.,NEyOffset=28.> {
      in_field => <-.Rd_Txt_Grid.field;
      axis_labels => <-.labels;
      x_axis_param {
         off_anno  = 0.9;
         axis_name = "X Axis";
      };
      y_axis_param {
         off_anno  = 0.9;
         axis_name = "Y Axis";
      };
   };
   group labels<NEportLevels={0,1}> {
      string x_labels<NEportLevels={2,1}>[] => <-.Rd_Txt_Grid.DVgrid_read.x_labels;
      string y_labels<NEportLevels={2,1}>[] => <-.Rd_Txt_Grid.DVgrid_read.y_labels;
   };
   MODS.city_plot city_plot {
      in_field => <-.Rd_Txt_Grid.field;
      CityParam {
         scale = 0.05;
      };
   };
};
