//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/dv_examp/text_seq_1.v#1 $

APPS.SingleWindowApp Text_Sequence<NEdisplayMode="maximized",
                                   NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows the Text Sequence reader being used to read a text data file that contains 3 arrays that are read into a uniform field with 3 node data components. The data file contains no \"meta-data\", that is, there is no usable information about the contents of the data file in the file.  All information about the bumber of arrays, size of the arrays, data types of the arrays, etc., must be specified through the user interface.";
      helpfile = "examples/examples_help.htm";
#ifdef MSDOS
      UItext.rows = 11;
#else
      UItext.rows = 13;
#endif
   };

   UI {
      shell {
         x = 10;
         y = 10;
      };
   };
   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.surf_plot.out_obj,
               <-.<-.<-.Axis3D.out_obj};
            Xform {
               mat = {
                  0.14759, 0.00554281, 0.019917, 0.,
                  0.0030532, 0.136157, -0.0605171, 0.,
                  -0.0204472, 0.06034, 0.134727, 0.,
                  0., 0., 0.,1.
               };
               xlate = {-3.30253,-2.46796,0.438152};
            };
         };
         Lights {
            Lights = {
               {
                  type="BiDirectional"
               },,,};
         };
      };
   };
   MODS.Read_Text_Sequence Rd_Txt_Sequence {
      param {
         filename = "$XP_PATH<0>/data/misc/sine_seq.txt";
         skip_lines = 2;
         ndim = 2;
         dims = {50,40};
         delim_ind = 2;
         ncomp = 3;
         comps = {
            {label="Sine",data_type=3,},
            {label="Cosine",data_type=3,},
            {label="SquareRoot",data_type=3,}};
      };
      DVread_seq_ascii {
         do = 1;
      };
   };
   MODS.extract_component extract_component {
      in_field => <-.Rd_Txt_Sequence.field;
      ExtrCompParam {
         component = 1;
      };
   };
   GEOMS.Axis3D Axis3D {
      in_field => <-.surf_plot.out_fld;
   };
   MODS.surf_plot surf_plot {
      in_field => <-.extract_component.out_fld;
      SurfPlotParam {
         scale = 9.51;
      };
   };
};
