/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/thresh_null.v#1 $
*/

APPS.MultiWindowApp Thresh_Null<NEdisplayMode="maximized"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows the difference between thresh and thresh_null.  Thresh is classified as a filter and works by setting null flags in the node data.  The mesh is not altered and the GD kit uses a structured mesh rendering routine - which only shows the external faces of the mesh.  Thresh_null is classified as a mapper and totally removes cells that contain null node data by writing out a new mesh.  The output is always an unstructured field and the GD kit uses the general 3d cells rendering routine - which shows all the cells of the mesh.";
      UItext {
#ifdef MSDOS
         rows = 15;
#else
         rows = 18;
#endif
      helpfile = "examples/examples_help.htm";
      };
   };

   MODS.Read_Field Read_Field<NEx=180.,NEy=30.> {
      read_field_ui {
         filename = "$XP_PATH/data/field/hydrogen.fld";
      };
   };
   MODS.downsize downsize<NEx=140.,NEy=100.> {
      in_field => <-.Read_Field.field;
      DownsizeParam {
         factor0 = 4.;
         factor1 = 4.;
         factor2 = 4.;
      };
   };
   MODS.threshold threshold<NEx=40.,NEy=180.> {
      in_field => <-.downsize.out_fld;
      ThreshParam {
         min_value => 8.51;
         max_value => 255.;
      };
   };
   MODS.thresh_null thresh_null<NEx=264.,NEy=200.> {
      in_field => <-.threshold.out_fld;
   };

   GDM.Uviewer3D Uviewer3D<NEx=170.,NEy=300.> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.threshold.out_obj};
            Xform {
               mat = {
                  -0.0608373,-0.0135175,0.0525675,0.,-0.0136006,0.0802392,0.00489303,0.,-0.0525463,-0.00511791,-0.0621288,0.,0.,0.,0.,1.
               };
            };
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 70;
                        defaultY = 400;
                     };
                  };
               };
            };
         };
      };
      Scene_Selector {
         input_views => {Scene.View.View, <-.Scene#1.View.View};
      };
      GDM.Uscene3D Scene#1 {
         Top {
            child_objs<NEportLevels={4,1}> => {
               <-.<-.<-.thresh_null.out_obj};
            Xform {
               mat = {
                  -0.0608373,-0.0135175,0.0525675,0.,-0.0136006,0.0802392,0.00489303,0.,-0.0525463,-0.00511791,-0.0621288,0.,0.,0.,0.,1.
               };
            };
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 600;
                        defaultY = 400;
                     };
                  };
               };
            };
         };
      };
   };
};
