/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/tile_vol.v#1 $
*/

APPS.SingleWindowApp TileVolumeSlices<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This simple network shows the use of the tile_volume macro. This technique is often used in medical imaging to get an overview of a volume, represented in a 2D visualization.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
   };
   MODS.downsize downsize {
      in_field => <-.Read_Field.field;
      DownsizeParam {
         factor0 = 1;
         factor1 = 1;
         factor2 = 4;
     };
   };
   MODS.tile_volume tile_volume {
      FieldIn => <-.downsize.out_fld;
      Tiled_Volume {
         start = 4;
         width = 4;
         height = 2;
      };
   };
   GDM.Uviewer2D Uviewer2D {
      Scene {
         Top {
            child_objs => {tile_volume.DataObject.obj};
         };
      };
   };
};
