/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/vintgr.v#1 $
*/

APPS.MultiWindowApp Volume_Integral<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20.> {
      demo_text = "This example shows the use of the volume_integr macro. This determines the length, area, or volume of an unstructured field. You can see the result using Modules->volume_integr.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_UCD Read_UCD<NEy=55.,NEx=198.> {
      read_ucd_ui {
         filename = "$XP_PATH<0>/data/ucd/bluntfin.inp";
      };
   };
   MODS.isovolume isovolume<NEx=341.,NEy=121.> {
      in_field => Read_UCD.field;
      IsoVolParam {
         iso_level => 1.84;
      };
   };
   MODS.external_faces external_faces<NEy=253.,NEx=330.> {
      in_field => isovolume.out_fld;
   };
   MODS.external_edges external_edges<NEy=132.,NEx=187.> {
      in_field => Read_UCD.field;
   };
   MODS.volume_integr volume_integr<NEx=506.,NEy=253.> {
      in_field => <-.isovolume.out_fld;
   };
   GDM.Uviewer3D Uviewer3D<NEy=330.,NEx=198.> {
      Scene {
         Top {
            child_objs => {
               external_faces.out_obj,external_edges.out_obj};
            Xform {
               mat = {
                  0.703732,-0.0989887,0.608613,0.,-0.101854,0.89217,0.262881,
0.,-0.60814,-0.263973,0.660251,0.,0.,0.,0.,1.
               };
               xlate = {-1.1513,-2.16129,-1.46212};
            };
         };
      };
   };
};
