/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/vol_rend3.v#1 $
*/

APPS.SingleWindowApp VolumeRendTransparent<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example demonstrates the use of the volume_render macro.  This shows how transparency effects can be achieved by controlling the datamap's Alpha parameter";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
   };
   MODS.volume_render volume_render {
      in_mesh => <-.Read_Field.field;
      DataObject {
         Obj {
            use_altobj = 0;
         };
         VolRenderDatamap {
            // mid_array didn't save correctly.  Had to add by hand.
            mid_array = {200, 2047.5, -0.5 };
            DataRange = {
               {
                  selectAlphaRange=0,,,,,,,
               },
               {
                  selectAlphaRange=0,,,,,,,,
               }};
            DatamapValue = {,
               {v1=0.1},
               {v1=0.25},};
         };
         Props {
            inherit = 0;
            ray_norm = "View";
         };
      };
      GDmodes_edit {
         surf = "Inherit";
      };
      curRange = 1;
   };
   MODS.bounds bounds {
      in_field => <-.Read_Field.field;
   };
   MODS.orthoslice orthoslice {
      in_field => <-.Read_Field.field;
      OrthoSliceParam {
         axis = 2;
      };
   };
   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               volume_render.out_obj,orthoslice.out_obj,bounds.out_obj};
            Xform {
               mat = {
                  0.0900151,0.0561813,0.0697562,0.,0.045691,0.0562579,-0.104271,
0.,-0.0770363,0.0990137,0.0196645,0.,0.,0.,0.,1.
               };
               dcenter = {-1.28884,-6.0321,
-3.1548};
            };
         };
         Camera {
            Camera {
               auto_norm = "None";
            };
         };
         View {
            View {
               renderer => "Software";
            };
         };
      };
   };
   UI {
      shell {
         x = 88;
         y = 88;
      };
   };
};
