/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/vol_rend4.v#1 $
*/

APPS.SingleWindowApp VolumeRendSFP<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=430.,NEy=66.> {
      demo_text = "This example shows the use of the volume_render macro. In particular the SFP (Simulated Fluorescence Process) ray algorithm is demonstrated here with the lobster volume. Note that the Ray Tracer is being used here so this technique is available in the software renderer only.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Read_Field Read_Field<NEx=400.,NEy=180.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/lobster.fld";
      };
   };

   int dims<NEportLevels=1,NEx=50.,NEy=30.>[3] => {120,120,2};

   byte floor<NEportLevels=1,NEx=250.,NEy=30.>[prod(.dims)] => init_array(prod(.dims),255,255);

   FLD_MAP.concat_2_arrays concat_2_arrays<NEx=250.,NEy=120.> {
      in1 => <-.floor;
      in2 => Read_Field.field.node_data[0].values;
   };

   int fielddims<NEportLevels=1,NEx=50.,NEy=120.>[3] => {120,120,36};

   FLD_MAP.uniform_scalar_field uniform_scalar_field<NEx=180.,NEy=190.> {
      mesh {
         in_dims => <-.<-.fielddims;
      };
      data {
         in_data => <-.<-.concat_2_arrays.out;
      };
   };

   MODS.volume_render volume_render<NEx=70.,NEy=260.> {
      in_mesh => <-.uniform_scalar_field.out;
      DataObject {
         VolRenderDatamap {
            mid_array = {255., 2047.5, -0.5 };
            // Only one data range
            DataRange[1] = {
               {
                  DataMaxValue=>(0 + <-.dataMax),,,,,,,,,,,,,maxActive=1,sizeActive=1
               }};
            DatamapValue[2] = {
               {
                  v2=0.,v3=0.,v4=0.,,
               },
               {
                  v2=0.,v3=0.,v4=1.,v1=1.,
               }};
            editable = 1;
         };
         Props {
            fat_ray = 0;
            inherit = 0;
            ray_algo = "SFP";
            sfp_absorb = 0.79;
            sfp_emit = 0.93;
         };
      };
   };

   GDM.Uviewer3D Uviewer3D<NEx=350.,NEy=260.> {
      Scene {
         Top {
            child_objs => {volume_render.out_obj};
            Xform {
               ocenter = {59.5,59.5,17.5};
               dcenter = {4.00136,4.055,1.13742};
               mat = {
                  -0.0292509,-0.0378594,0.0391381,0.,0.0497041,-0.000418093,0.0367434,
0.,-0.0222403,0.0488593,0.0306411,0.,0.,0.,0.,1.
               };
               xlate = {-4.00135,-4.055,-1.13742};
               center = {59.5,59.5,17.5};
            };
         };
         Camera {
            Camera {
               perspec = 1;
               front = 1.;
            };
         };
         View {
            View {
               renderer => "Software";
            };
         };
      };
      Scene_Editor {
         Camera_Editor {
            GDcamera_edit {
               front = 1.;
            };
         };
         Datamap_Editor {
            IUI {
               Options {
                  IUI {
                     optionList {
                        selectedItem = 3;
                     };
                     InputOutput {
                        IUI {
                           panel {
                              visible = 1;
                           };
                           Dmap_browser {
                              text = "GreyScale";
                           };
                        };
                     };
                  };
               };
            };
            selectedDmap = 1;
         };
      };
   };
   UI {
      shell {
         x = 200;
         y = 80;
      };
   };
};
