/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/dv_examp/vol_rend5.v#1 $
*/

// Instance volume_render
// Open the DataObject and delete the (Vol)MinMax and VolRenderDatamap.
// Replace with a DefaultMinMax and DefaultLinear datamap object.
// Connect the Colormap Editor to volume_render data object.

APPS.SingleWindowApp VolumeRendShells<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=320.,NEy=55.> {
      demo_text = "This example shows how the volume_render macro can be used in conjunction with the ColormapEditor to achieve complex transparency/opacity effects. The key element here is that the ColormapEditor exposes the ability to change the opacity levels in the colormap which allows you to select shells of data.  Note that this example uses a custom version of volume_render that has had its datamap/colormap editor removed.";
      helpfile = "examples/examples_help.htm";
   };

   UI {
      shell {
         x = 380;
         y = 100;
      };
   };
   GDM.Uviewer3D Uviewer3D<NEx=500,NEy=400> {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.volume_render.out};
            Xform {
               ocenter = {31.5,44.,31.5};
               dcenter = {4.,5.5873,4.};
               mat = {
                  0.0891684,-0.0223164,0.0454995,0.,0.0223405,-0.0653434,-0.0758316,
0.,0.0454877,0.0758385,-0.0519483,0.,0.,0.,0.,1.
               };
               xlate = {-4.,-5.5873,-4.};
               center = {31.5,44.,31.5};
            };
         };
         Camera {
            Camera {
               auto_norm = "None";
               perspec = 1;
               front = 1.;
            };
         };
         View {
            View {
               trigger = 1;
               renderer => "Software";
            };
         };
      };
      Scene_Editor {
         Camera_Editor {
            GDcamera_edit {
               front = 1.;
            };
         };
      };
   };
   MODS.Read_Field Read_Field<NEx=99.,NEy=55.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
   };
   MODS.crop crop<NEx=231.,NEy=132.> {
      in_field => <-.Read_Field.field;
      CropParam {
         min = {0,25,0};
         max = {63,63,63};
      };
   };
   macro volume_render<NEx=385.,NEy=264.> {
      Mesh_Unif+Node_Data &in_mesh<NEcolor1=16711680,NEportLevels={2,1},NEx=14.,NEy=39.> {
         nspace = 3;
         ndim = 3;
         nnode_data = 1;
         node_data {
            veclen = 1;
         };
      } => <-.crop.out_fld;
      GDmodes_edit GDmodes_edit<NEx=182.,NEy=39.> {
         points = "Inherit";
         lines = "Inherit";
         volume = "Ray Tracer";
         bounds = "Inherit";
         shell_vis = 1;
         modes => <-.DataObject.Modes;
      };
      GDprops_edit GDprops_edit<NEx=350.,NEy=39.> {
         fat_ray = 0;
         inherit = 0;
         shell_vis = 1;
         props => <-.DataObject.Props;
      };
      UImod_panel UImod_panel<NEx=518.,NEy=147.> {
         title => name_of(<-.<-);
         option {
            set = 1;
         };
      };
      macro modes_ui<NEx=245.,NEy=255.> {
         UIframe modes_frame {
            y = 0;
            width => <-.<-.UImod_panel.clientWidth;
            height => ((<-.vol_rb.y + <-.vol_rb.height) + 4);
            parent<NEportLevels={3,0}> => <-.<-.UImod_panel;
         };
         UIlabel modes_label {
            x = 4;
            y = 0;
            width => (<-.modes_frame.clientWidth - 8);
            parent => <-.modes_frame;
            label => "Modes";
            alignment = "center";
         };
         UIoption inherit {
            label => "Inherit";
            set = 1;
         };
         UIoption none {
            label => "None";
         };
         UIoption no_light {
            label => "No Lighting";
         };
         UIoption flat {
            label => "Flat Shading";
         };
         UIoption gouraud {
            label => "Gouraud Shading";
         };
         UIoptionMenu surf_rb {
            x = 0;
            y => ((<-.modes_label.y + <-.modes_label.height) + 4);
            parent => <-.modes_frame;
            label => "Surface";
            cmdList => {
               <-.inherit,<-.none,<-.no_light,<-.flat,<-.gouraud
            };
            selectedItem => <-.<-.GDmodes_edit.surf;
            alignment = "left";
         };
         UIoption vol_inherit {
            label => "Inherit";
         };
         UIoption vol_none {
            label => "None";
         };
         UIoption btf {
            label => "BTF texture";
         };
         UIoption ray_tracer {
            label => "Ray tracer";
            set = 1;
         };
         UIoptionMenu vol_rb {
            x = 0;
            y => ((<-.surf_rb.y + <-.surf_rb.height) + 4);
            parent => <-.modes_frame;
            label => "Volume";
            cmdList => {<-.vol_inherit,
               <-.vol_none,<-.btf,<-.ray_tracer};
            selectedItem => <-.<-.GDmodes_edit.volume;
            alignment = "left";
         };
      };
      macro props_ui<NEx=455.,NEy=255.> {
         UIframe props_frame {
            y => ((<-.<-.modes_ui.modes_frame.y + <-.<-.modes_ui.modes_frame.height) + 4);
            width => <-.<-.UImod_panel.clientWidth;
            height => ((<-.sfp_emit.y + <-.sfp_emit.height) + 8);
            parent<NEportLevels={3,0}> => <-.<-.UImod_panel;
         };
         UIlabel props_label {
            x = 4;
            y = 0;
            width => (<-.props_frame.clientWidth - 8);
            parent => <-.props_frame;
            label => "Properties";
            alignment = "center";
         };
         UIoption interp_pt {
            label => "Point";
         };
         UIoption interp_tri {
            label => "Trilinear";
            set = 1;
         };
         UIoptionMenu interp_rb {
            x = 0;
            y => ((<-.props_label.y + <-.props_label.height) + 4);
            active => switch(((<-.<-.GDprops_edit.ray_algo == 0) + 1),0,1);
            parent => <-.props_frame;
            label => "Interpolation";
            cmdList => {<-.interp_pt,
               <-.interp_tri};
            selectedItem => <-.<-.GDprops_edit.voxel_interp;
            alignment = "left";
         };
         UIoption ray_direct {
            label => "Direct Composite";
            set = 1;
         };
         UIoption ray_ave {
            label => "Average Value";
         };
         UIoption ray_max {
            label => "Maximum Value";
         };
         UIoption ray_dist {
            label => "Distance to Max";
         };
         UIoption ray_sfp {
            label => "SFP";
         };
         UIoptionMenu ray_rb {
            x = 0;
            y => ((<-.interp_rb.y + <-.interp_rb.height) + 4);
            parent => <-.props_frame;
            label => "Ray Algorithm";
            cmdList => {
               <-.ray_direct,<-.ray_ave,<-.ray_max,<-.ray_dist,<-.ray_sfp
            };
            selectedItem => <-.<-.GDprops_edit.ray_algo;
            alignment = "left";
         };
         UIoption dist_glob {
            label => "Global";
            set = 1;
         };
         UIoption dist_view {
            label => "View";
         };
         UIoption dist_ray {
            label => "Ray";
         };
         UIoptionMenu dist_rb {
            x = 0;
            y => ((<-.ray_rb.y + <-.ray_rb.height) + 4);
            active => switch(((<-.<-.GDprops_edit.ray_algo == 3) + 1),0,1);
            parent => <-.props_frame;
            label => "Distance Normalize";
            cmdList => {<-.dist_glob,
               <-.dist_view,<-.dist_ray};
            selectedItem => <-.<-.GDprops_edit.ray_norm;
            alignment = "left";
         };
         UItoggle fat_ray {
            y => ((<-.dist_rb.y + <-.dist_rb.height) + 4);
            parent => <-.props_frame;
            label => "Fat Ray";
            set => <-.<-.GDprops_edit.fat_ray;
         };
         UIslider sfp_absorb {
            y => ((<-.fat_ray.y + <-.fat_ray.height) + 4);
            active => switch(((<-.<-.GDprops_edit.ray_algo == 4) + 1),0,1);
            parent => <-.props_frame;
            min = 0.;
            max = 1.;
            value => <-.<-.GDprops_edit.sfp_absorb;
            title => "SFP Absorption";
         };
         UIslider sfp_emit {
            y => ((<-.sfp_absorb.y + <-.sfp_absorb.height) + 4);
            active => switch(((<-.<-.GDprops_edit.ray_algo == 4) + 1),0,1);
            parent => <-.props_frame;
            min = 0.;
            max = 1.;
            value => <-.<-.GDprops_edit.sfp_emit;
            title => "SFP Emission";
         };
      };
      UItoggle alt_object {
         y => ((<-.props_ui.props_frame.y + <-.props_ui.props_frame.height) + 6);
         width => parent.clientWidth;
         parent => <-.UImod_panel;
         label => "Alternate Object";
         set => <-.DataObject.Obj.use_altobj;
      };
      olink out_obj<NEx=686.,NEy=147.>;
      DataObject DataObject<NEx=35.,NEy=255.> {
         Datamap {
            DataRange[8] = {
               
               {
                  DataMaxValue=66.3429718,,,,,,,,,,,,controlPoints=>
                  {DatamapValue[0],
                     DatamapValue[1]},
               },
               {
                  DataMinValue=><-.DataRange[0].DataMaxValue,,,,,DataMaxValue=77.13294983,,,,,,,,,,,,controlPoints=>
                  {DatamapValue[2],
                     DatamapValue[3]},
               },
               {
                  DataMinValue=><-.DataRange[1].DataMaxValue,,,,,DataMaxValue=87.15222168,,,,,,,,,,,,controlPoints=>
                  {DatamapValue[4],
                     DatamapValue[5]},
               },
               {
                  DataMinValue=><-.DataRange[2].DataMaxValue,,,,,DataMaxValue=132.6242828,,,,,,,,,,,,controlPoints=>
                  {DatamapValue[6],
                     DatamapValue[7]},
               },
               {
                  DataMinValue=><-.DataRange[3].DataMaxValue,,,,,DataMaxValue=143.4142609,,,,,,,,,,,,controlPoints=>
                  {DatamapValue[8],
                     DatamapValue[9]},
               },
               {
                  DataMinValue=><-.DataRange[4].DataMaxValue,,,,,DataMaxValue=154.2042389,,,,,,,,,,,,controlPoints=>
                  {DatamapValue[10],
                     DatamapValue[11]},
               },
               {
                  DataMinValue=><-.DataRange[5].DataMaxValue,,,,,DataMaxValue=215.0905457,,,,,,,,,,,,controlPoints=>
                  {DatamapValue[12],
                     DatamapValue[13]},
               },
               {
                  DataMinValue=><-.DataRange[6].DataMaxValue,,,,,,,,,,,,,,,,,controlPoints=>
                  {DatamapValue[14],
                     DatamapValue[15]},
               }
            };
            DatamapValue[16] = {
               
               {
                  v1=0.,v2=0.6600000262,v3=1.,v4=1.,value=0.
               },
               {
                  v1=0.,v2=0.4917646646,v3=1.,v4=1.,value=66.3429718
               },
               {
                  v1=0.,v2=0.4917646646,v3=1.,v4=1.,value=66.3429718
               },
               {
                  v1=0.4759150147,v2=0.4281244874,v3=1.,v4=1.,value=77.13294983
               },
               {
                  v1=0.4759150147,v2=0.4281244874,v3=1.,v4=1.,value=77.13294983
               },
               {
                  v1=0.,v2=0.3794358373,v3=1.,v4=1.,value=87.15222168
               },
               {
                  v1=0.,v2=0.3794358373,v3=1.,v4=1.,value=87.15222168
               },
               {
                  v1=0.006262000185,v2=0.3151426613,v3=1.,v4=1.,value=132.6242828
               },
               {
                  v1=0.006262000185,v2=0.3151426613,v3=1.,v4=1.,value=132.6242828
               },
               {
                  v1=0.512041986,v2=0.2887949944,v3=1.,v4=1.,value=143.4142609
               },
               {
                  v1=0.512041986,v2=0.2887949944,v3=1.,v4=1.,value=143.4142609
               },
               {
                  v1=0.01830399968,v2=0.2844879925,v3=1.,v4=1.,value=154.2042389
               },
               {
                  v1=0.01830399968,v2=0.2844879925,v3=1.,v4=1.,value=154.2042389
               },
               {
                  v1=0.,v2=0.19727166,v3=1.,v4=1.,value=215.0905457
               },
               {
                  v1=0.,v2=0.19727166,v3=1.,v4=1.,value=215.0905457
               },
               {
                  v1=1.,v2=0.,v3=1.,v4=1.,value=255.
               }
            };
         };
         Props {
            fat_ray<NEdisplayMode="open"> = 0;
            inherit = 0;
         };
         Modes<NEx=539.,NEy=209.> {
            mode = {0,0,0,3,0};
         };
         Obj<NEdisplayMode="open",NEy=308.> {
            use_altobj = 1;
         };
         in => <-.in_mesh;
      };
      link out<NEportLevels={1,2},NEx=350.,NEy=363.> => DataObject.obj;
   };

   CMAP_EDTR.ColorMapEditor ColormapEditor<NEx=170.,NEy=330.> {
      InObj => <-.volume_render.out;
      in_field => <-.crop.out_fld;
      UIshell {
         x = 0;
         y = 100;
      };
      ColorMapEditorParams {
         histo_enable = 1;
         histo_log = 1;
      };
   };
};
